#include "mbed.h"
#include "uart.h"
#include "interpret.h"
#include "do.h"
#include "MCP23017.h"



//---------------------------------------
// Hardware recources
//---------------------------------------
MCP23017 *DO_I2C;    //


//---------------------------------------
// Prototypes
//---------------------------------------




//---------------------------------------
// Internal variables
//---------------------------------------
static int DO_PinMapping[ DO_NUMBER_PINS ];  // array, keeps MCP23017 pin number for easy access


//---------------------------------------
// External variables
//---------------------------------------



//---------------------------------------
// Global Functions
//---------------------------------------
void DO_init( void )
{
    DO_PinMapping[0] = DO_PIN1;
    DO_PinMapping[1] = DO_PIN2;
    DO_PinMapping[2] = DO_PIN3;
    DO_PinMapping[3] = DO_PIN4;
    DO_PinMapping[4] = DO_PIN5;
    DO_PinMapping[5] = DO_PIN6;
    DO_PinMapping[6] = DO_PIN7;
    DO_PinMapping[7] = DO_PIN8;
    DO_PinMapping[8] = DO_PIN9;
    DO_PinMapping[9] = DO_PIN10;
    DO_PinMapping[10] = DO_PIN11;
    DO_PinMapping[11] = DO_PIN12;
    DO_PinMapping[12] = DO_PIN13;
    DO_PinMapping[13] = DO_PIN14;
    DO_PinMapping[14] = DO_PIN15;
    DO_PinMapping[15] = DO_PIN16;

    DO_I2C = new MCP23017( p9, p10, DO_I2C_ADD);
    DO_I2C->config(0xFFFF,0,0);           // set to inputs, no pull-ups, not-inverted
}



// process commands
void DO_deviceID_process( void )
{
    unsigned int temp32U = 0;
    unsigned short portTemp = 0;
    int i;
    int j;

    temp32U = 0x000000FF & ( (unsigned int)uartBuffer[INT_BUF_1DATA] );

    switch( uartBuffer[ INT_BUF_COMMAND ] ) {
            //--------------------
        case DO_GET_SINGLE:
            //--------------------
        {
            if( (temp32U == 0) || (temp32U > DO_NUMBER_PINS) ) {
                // Generate acknowledge
                INT_generateACKFrame(INT_ID_DO, INT_COM_VAL_NOTVALID);

                break;
            }

            temp32U = DO_I2C->read_bit( DO_PinMapping[temp32U - 1] );

            // Generate acknowledge
            uartBuffer[INT_BUF_DEVICEID] = INT_ID_DO;
            uartBuffer[INT_BUF_COMMAND] = INT_COM_ACK;
            uartBuffer[INT_BUF_NUM] = 1;
            uartBuffer[INT_BUF_1DATA] = (char)(0x000000FF & temp32U);
            UART_handler.bytesToWrite = 4;
            break;

        }


        //--------------------
        case DO_GET_PORT:
            //--------------------
        {
            temp32U = 0;

            portTemp = DO_I2C->read_mask(0xFFFF);

            for( i = 0; i < 16; i++ ) {
                if(  portTemp & (1 << i) ) {
                    for( j = 0; j < 16; j++ ) {
                        if( DO_PinMapping[j] == i ) {
                            temp32U |= (1 << j);
                        }
                    }//for j

                }// if
            }// for i

            /*
                        for( i = 0; i < 16; i++ )
                        {
                           if(  portTemp & (1 << i) )
                           {
                                for( j = 1; j < 17; j++ )
                                {
                                    if( DO_PinMapping[j] == i )
                                    {
                                        temp32U |= (1 << (j-1));
                                    }
                                }//for j

                           }// if
                        }// for i
            */

            // Generate acknowledge
            uartBuffer[INT_BUF_DEVICEID] = INT_ID_DO;
            uartBuffer[INT_BUF_COMMAND] = INT_COM_ACK;
            uartBuffer[INT_BUF_NUM] = 2;
            uartBuffer[INT_BUF_1DATA]       = (char)(0x000000FF & (temp32U >> 8) );
            uartBuffer[INT_BUF_1DATA + 1]   = (char)(0x000000FF & (temp32U) );
            UART_handler.bytesToWrite = 5;
            break;

        }


        //-----------------
        default:
            //-----------------
        {
            // Command not supported
            INT_generateACKFrame(INT_ID_DO, INT_COM_COM_NOTSUPP);
        }
    }//switch

}

//---------------------------------------
// Internal Functions
//---------------------------------------

