#include "mbed.h"


//---------------------------------------
// Definitions
//---------------------------------------
#define DIDO_I2C_ADD ( I2C_BASE_ADDRESS + (5 << 1) )    //


#define DIDO_DO1    ( 2 )       // MCP23008 GPIO: 2
#define DIDO_DO2    ( 1 )       // MCP23008 GPIO: 1
#define DIDO_RELAY  ( 0 )       // MCP23008 GPIO: 0
#define DIDO_DI1    ( 7 )       // MCP23008 GPIO: 7
#define DIDO_DI2    ( 6 )       // MCP23008 GPIO: 6
#define DIDO_DI3    ( 5 )       // MCP23008 GPIO: 5
#define DIDO_DI4    ( 4 )       // MCP23008 GPIO: 4
#define DIDO_DI5    ( 3 )       // MCP23008 GPIO: 3
 

//---------------------------------------
// Enums
//---------------------------------------





//---------------------------------------
// Structures
//---------------------------------------




//---------------------------------------
// Global Variables
//---------------------------------------



//---------------------------------------
// Global Functions
//---------------------------------------
void DIDO_init( void );

void DIDO_setDO1ON( void );
void DIDO_setDO1OFF( void );
void DIDO_setDO2ON( void );
void DIDO_setDO2OFF( void );
void DIDO_setRelayON( void );
void DIDO_setRelayOFF( void );

// Return:
// 0 = off, or low input level
// >= 1: On, or high input level
int DIDO_getDO1( void );
int DIDO_getDO2( void );
int DIDO_getRelay( void );
int DIDO_getDI1( void );
int DIDO_getDI2( void );
int DIDO_getDI3( void );
int DIDO_getDI4( void );
int DIDO_getDI5( void );
