#include "mbed.h"
#include "dido.h"
#include "MCP23008.h"


//---------------------------------------
// Hardware recources
//---------------------------------------
MCP23008 *DIDO_I2C;    //


//---------------------------------------
// Prototypes
//---------------------------------------



//---------------------------------------
// Internal variables
//---------------------------------------
static unsigned char DIDO_doState;    // keeps last written DO state 


//---------------------------------------
// External variables
//---------------------------------------



//---------------------------------------
// Global Functions
//---------------------------------------

void DIDO_init( void )
{
    unsigned char direction;
    
    direction = 0x00;   // Set all to outputs
    direction = ( (1<<DIDO_DI1) | (1<<DIDO_DI2) | (1<<DIDO_DI3) | (1<<DIDO_DI4) | (1<<DIDO_DI5) ); // set some to inputs   

    DIDO_I2C = new MCP23008( p9, p10, DIDO_I2C_ADD);
    DIDO_I2C->config(direction, 0 , 0);  // set direction, no pull-ups, 0
    
    DIDO_setDO1OFF();
    DIDO_setDO2OFF();
    DIDO_setRelayOFF();
  
}


void DIDO_setDO1ON( void )
{
    DIDO_doState |= (1 << DIDO_DO1);  
    DIDO_I2C->write_bit(0, DIDO_DO1);
}

void DIDO_setDO1OFF( void )
{
    DIDO_doState &= ~(1 << DIDO_DO1);  
    DIDO_I2C->write_bit(1, DIDO_DO1);
}


void DIDO_setDO2ON( void )
{
    DIDO_doState |= (1 << DIDO_DO2);  
    DIDO_I2C->write_bit(0, DIDO_DO2);
}

void DIDO_setDO2OFF( void )
{
    DIDO_doState &= ~(1 << DIDO_DO2);  
    DIDO_I2C->write_bit(1, DIDO_DO2);
}


void DIDO_setRelayON( void )
{
    DIDO_doState |= (1 << DIDO_RELAY);  
    DIDO_I2C->write_bit(1, DIDO_RELAY);
}

void DIDO_setRelayOFF( void )
{
    DIDO_doState &= ~(1 << DIDO_RELAY);  
    DIDO_I2C->write_bit(0, DIDO_RELAY);
}


int DIDO_getDO1( void )
{
    return ( DIDO_doState & (1 << DIDO_DO1) ); 
}


int DIDO_getDO2( void )
{
    return ( DIDO_doState & (1 << DIDO_DO2) ); 
}


int DIDO_getRelay( void )
{
    return ( DIDO_doState & (1 << DIDO_RELAY) ); 
}


int DIDO_getDI1( void )
{
    return DIDO_I2C->read_bit(DIDO_DI1);
}


int DIDO_getDI2( void )
{
    return DIDO_I2C->read_bit(DIDO_DI2);
}


int DIDO_getDI3( void )
{
    return DIDO_I2C->read_bit(DIDO_DI3);
}


int DIDO_getDI4( void )
{
    return DIDO_I2C->read_bit(DIDO_DI4);
}


int DIDO_getDI5( void )
{
    return DIDO_I2C->read_bit(DIDO_DI5);
}


//---------------------------------------
// Internal Functions
//---------------------------------------

