#include "mbed.h"



//---------------------------------------
// Definitions
//---------------------------------------
#define DI_PIN9_24_I2C_ADD  ( I2C_BASE_ADDRESS + (6 << 1) )    // I2C_BASE_ADDRESS is defined in MCP23017
#define DI_PIN1_8_I2C_ADD   ( I2C_BASE_ADDRESS + (4 << 1)  )    // I2C_BASE_ADDRESS is defined in MCP23017
 
// define pin number (0..15) of MCP23017
typedef enum
{
    DI_PIN1 = 7,      
    DI_PIN2 = 6,     
    DI_PIN3 = 5,   
    DI_PIN4 = 4,   
    DI_PIN5 = 3,   
    DI_PIN6 = 2,   
    DI_PIN7 = 1, 
    DI_PIN8 = 0,   
    DI_PIN9 = 15,   
    DI_PIN10 = 14,  
    DI_PIN11 = 13,   
    DI_PIN12 = 12,   
    DI_PIN13 = 11,  
    DI_PIN14 = 10,   
    DI_PIN15 = 9,  
    DI_PIN16 = 8,   
    DI_PIN17 = 7, 
    DI_PIN18 = 6,  
    DI_PIN19 = 5,  
    DI_PIN20 = 4,  
    DI_PIN21 = 3, 
    DI_PIN22 = 2,  
    DI_PIN23 = 1,  
    DI_PIN24 = 0,
    //--------------- 
    CNT_DI_ePinTable
}DI_ePinTable;

#define DI_NUMBER_PINS  ( 24 )

#define DI_LEVEL_LOW    ( 8 )
#define DI_LEVEL_HIGH   ( 9 )


//---------------------------------------
// Enums
//---------------------------------------

// Global commands 0 - 20 are defined in interpret.h
// Commands 21 - 127 are HW-unit commands
typedef enum
{
    DI_SET_LEVEL_LOW = 21,     // 21: setLevelLow
    DI_GET_LEVEL_LOW,          // 22: getLevelLow
    DI_SET_LEVEL_HIGH,          // 23: setLevelHigh
    DI_GET_LEVEL_HIGH,          // 24: getLevelHigh
    DI_SET_SINGLE,              // 25: setSingle
    DI_CLEAR_SINGLE,            // 26: clearSingle
    DI_GET_SINGLE,              // 27: getSingle
    DI_SET_PORT,                // 28: setPort
    DI_GET_PORT,                // 29: getPort
    //----------------
    CNT_eDI_command
}eDI_command;



//---------------------------------------
// Structures
//---------------------------------------



//---------------------------------------
// Global Variables
//---------------------------------------



//---------------------------------------
// Global Functions
//---------------------------------------
void DI_init( void );
void DI_deviceID_process( void );
