

//----------------------------------------
// Includes
//----------------------------------------
#include "mbed.h"
#include "crc16.h"


//----------------------------------------
// Prototype declaration
//----------------------------------------


//----------------------------------------
// global Variables
//----------------------------------------


//----------------------------------------
// Function
//----------------------------------------

//---------------------------------------------------------------------
//  Function Name:  calcCRC16
//  Description:    calculate CRC16 from preview CRC16 value and new data byte
//
//  Inputs:                 - uint8 *ptrData:   first data byte
//                                  - uint16 numbBytes: Number of data bytes to process
//                                  - uint16 *ptrCRC16: return value
//
//  Returns:        None
//
//  Last Change:    05.04.2013
//-----------------------------------------------------------------------
void calcCRC16(char *ptrData, int numbBytes, unsigned short *ptrCRC16)
{
    unsigned short i;
    unsigned short i_bytes;
    unsigned short CRC16;
    char data;
    
    CRC16 = CRC16_STARTVALUE;

    for(i_bytes=0; i_bytes < numbBytes; i_bytes++)
    {
        data = *ptrData++;  // get new data, inc pointer

        for(i=0;i<8;i++)
        {
            if( ( (CRC16 ^ data) & 0x01) == 0x01 )
            {
                CRC16 >>= 1;
                CRC16 ^= CRC16_POLYNOME;
            }//if
            else
            {
                CRC16 >>= 1;
            }//else
            
            data >>= 1;     // shift data 1 bit right, dividing it by 2
        }//for

    }//for i_bytes

    *ptrCRC16 = CRC16; //return CRC16
}
