#include "mbed.h"
#include "can.h"



//---------------------------------------
// Hardware recources
//---------------------------------------
CAN can1(p30, p29);



//---------------------------------------
// Prototypes
//---------------------------------------
static void CAN_rxCallback( void );



//---------------------------------------
// Internal variables
//---------------------------------------
static CANMessage CAN_rxMessage;
static bool CAN_newFrame = false;



//---------------------------------------
// External variables
//---------------------------------------



//---------------------------------------
// Global Functions
//---------------------------------------
void CAN_init( void )
{   
    CAN_newFrame = false;
    can1.reset();
    can1.frequency( CAN_FREQUENCY );
    can1.attach( &CAN_rxCallback );
}


// Return:
// 0 --> no new frame
// 1 --> new frame was received
int CAN_get( int *ptrID, char *ptrLen, char *ptrData )
{
    int i;
    
    // No new frame
    if( CAN_newFrame == false )
    {
        *ptrID = 0;
        *ptrLen = 0;
        return 0;
    }
    
    // New frame was received
    *ptrID = CAN_rxMessage.id;
    *ptrLen = CAN_rxMessage.len; 
    for( i = 0; i < CAN_rxMessage.len; i++)
    {
        *ptrData = CAN_rxMessage.data[i];
        ptrData++;
    }
    
    CAN_newFrame = false;
    
    return 1;
}


// Return:
// 0: ID, Len outside limit or CAN hardware problems
// 1: Data have been send
int CAN_send( int ID, char Len, char *ptrData )
{   
    // Check limits
    if( Len > 8 )
    {
        return 0;
    }
    
    if( (ID < 0) || (ID > 0x7FF) )
    {
        return 0;
    } 


    if( can1.write( CANMessage(ID, ptrData, Len) ) )
    {
        return 1;
    }
   
    // Error sending data --> reset init CAN
    CAN_init();
    return 0;
}


//---------------------------------------
// Internal Functions
//---------------------------------------

static void CAN_rxCallback( void )
{
    can1.read(CAN_rxMessage);
    CAN_newFrame = true;
}

