#include "mbed.h"



//---------------------------------------
// Definitions
//---------------------------------------
#define ANA_SW_TIMER_PERIOD     10000   // [us] Period time of call
#define ANA_LP_FILTER_SHIFT_ANA1    3
#define ANA_LP_FILTER_SHIFT_ANA2    3
#define ANA_LP_FILTER_SHIFT_ANA3    3


//---------------------------------------
// Enums
//---------------------------------------

typedef enum
{
    ANA_CH1,
    ANA_CH2,
    ANA_CH3,
    //-----------------
    CNT_eANA_Channels
}eANA_Channels;


//---------------------------------------
// Structures
//---------------------------------------



//---------------------------------------
// Global Variables
//---------------------------------------



//---------------------------------------
// Global Functions
//---------------------------------------
void ANA_init( void );
unsigned short ANA_getRaw(int channel);
unsigned short ANA_getFiltered( int channel );
float ANA_scale(float offset, float gain, unsigned short input);