#include "mbed.h"


//---------------------------------------
// Definitions
//---------------------------------------
#define RS485_BUFFER_LENGTH      512
#define RS485_RX_TIMEOUT_US      300
#define RS485_TX_TIMEOUT_US      300
#define RS485_BAUDRATE           38400  // Same as Display
#define RS485_BITS               8
#define RS485_STOPBIT            1

//---------------------------------------
// Enums
//---------------------------------------
typedef enum
{
    RS485_MODE_LISTEN,
    RS485_MODE_RX_READY,
    //-----------------
    CNT_eRS485_mode
}eRS485_mode;


//---------------------------------------
// Structures
//---------------------------------------
typedef struct
{
    eRS485_mode mode;       // mode of RS485 hardware
    char *ptrRXBuffer;      // actual read position in buffer
    char bytesToRead;       // Number of received bytes
}sRS485_handler;



//---------------------------------------
// Global Variables
//---------------------------------------
extern sRS485_handler RS485_handler;
extern char RS485Buffer[RS485_BUFFER_LENGTH];


//---------------------------------------
// Global Functions
//---------------------------------------
void RS485_init( void );
void RS485_reset( void );            // clear all RS485 registers, --> restart    
int RS485_receiveData( char *& ptrData, int *ptrNumBytes );
int RS485_sendData( char *ptrDataToSend, int NumBytes );
int RS485_sendDataWithCRC( char *ptrDataToSend, int NumBytes );