#include "mbed.h"
#include "LIS2MDL.h"

#define LIS2MDL_intPin  p16 // interrupt for magnetometer data ready

uint8_t MODR = MODR_100Hz;
int16_t temp[3] = {0, 0, 0};
float magBias[3] = {0,0,0}, magScale[3]  = {0,0,0};

//Attach interrupt to this pin if you want to use magnetometer sensor interrupt
// Before that make sure to set the correct interrupt value in the INT_CTRL_REG, INT_THS_L_REG and the INT_THS_H_REG (threshold value)
DigitalIn interruptPin(LIS2MDL_intPin);

// The itracker has the LIS2MDL sensor on the 13 and 11 I2C pins
I2C i2c(p13,p11);

// main() method. Runs in its own thread in the OS
int main()
{
    //Create LIS2MDL object
    LIS2MDL sensor(i2c, LIS2MDL_ADDRESS);
    
    //Reset the sensor to ensure correct starting config register values
    sensor.reset();
    wait(3);
    
    //Intialise the CHIP with the MODR value chosen
    sensor.init(MODR);
    
    //Test the Chip ID. Should return 64 (0x40)
    sensor.getChipID();
    
    // Calcaulte the offset bias to be used in future reading. See self check for example usage
    sensor.offsetBias(magBias, magScale);
    
    // Read the internal temp sensor
    sensor.readTemperature();

    //Get readings from the sensor;
    for(int i=0; i<60; i++) {
        int16_t temp[3] = {0, 0, 0};
        sensor.readData(temp);
        wait(0.1);
    }
}

