#include "mbed.h"
#include "SEGGER_RTT.h"

DigitalOut gsm_on(p6);
DigitalOut gsm_pwrkey(p15);

void gsm_pwr_on();
void gsm_boot();
void check_gsm();
// main() runs in its own thread in the OS

Serial gsm(p20, p12); // tx, rx

void callback_ex()
{
    // Note: you need to actually read from the serial to clear the RX interrupt
    while(10) {
        SEGGER_RTT_printf(0, "content from serial :: %c \n", gsm.getc());
    }
}

int main()
{
    gsm.baud(9600);
    gsm.attach(&callback_ex);

    SEGGER_RTT_printf(0, "POWERING GSM Module \n");
    gsm_pwr_on();
    SEGGER_RTT_printf(0, "INITIATING GSM MODULE bootup \n");
    gsm_boot();
    SEGGER_RTT_printf(0, "GSM power up sequence complete...check LED1 \n");
    wait(30);
    for(int i=0; i<5; i++) check_gsm();

}

void gsm_pwr_on()
{
    gsm_on = 0;
    wait_ms(200);
    gsm_on = 1;
    wait_ms(200);
}

void gsm_pwr_off()
{
    gsm_on = 1;
    wait_ms(200);
    gsm_on = 0;
    wait_ms(200);
}

void gsm_boot()
{
    gsm_pwrkey = 0;
    wait(2.0);
    gsm_pwrkey = 1;
    wait(1.0);
}

void check_gsm()
{
    SEGGER_RTT_printf(0, "send ATI command to check GSM module \n");
    gsm.printf("ATI\r\n");
    wait(1);
}