#include "mbed.h"
#include "BME280_SPI.h"
#include "SEGGER_RTT.h"

// main() runs in its own thread in the OS
int main() {
    BME280_SPI sensor(p3, p5, p4, p2); // mosi, miso, sclk, cs
    
    while (true) {
       SEGGER_RTT_printf(0, "%2.2f degC, %04.2f hPa, %2.2f %%\n", sensor.getTemperature(), sensor.getPressure(), sensor.getHumidity());
       wait(5.0);
    }
}

