#ifndef WII_NUNCHUCK_H
#define WII_NUNCHUCK_H

#include "mbed.h"

// I2C
#define NUNCHUCK_ADDR     0xA4  // 0x52 << 1
#define NUNCHUCK_REGADDR  0x40  // 
#define NUNCHUCK_READLEN  0x06  //
#define I2C_ACK 0
#define I2C_READ_DELAY  0.01

#define Joy_X   0
#define Joy_Y   1
#define Acc_X   2
#define Acc_Y   3
#define Acc_Z   4
#define Button  5

class WiiNunchuck {
public:
    WiiNunchuck(PinName p_sda, PinName p_scl);
    //read();
    unsigned char joyx();
    unsigned char joyy();
    int accx();
    int accy();
    int accz();
    bool buttonc();
    bool buttonz();
private:
    I2C i2c;
    Timer timer;
    bool WiiNunInitFlag; //= false;
    char readBuf[NUNCHUCK_READLEN];
    unsigned char joyX, joyY;
    int accX, accY, accZ;
    bool buttonC, buttonZ;
    bool init();
    void read();
};


#endif