#include "mbed.h"
#include "WiiNunchuck.h"

WiiNunchuck::WiiNunchuck(PinName p_sda, PinName p_scl):i2c(p_sda, p_scl)
{
    WiiNunInitFlag = init();
    timer.start();
}


bool WiiNunchuck::init()
{
    bool result = false; 
    unsigned char cmd[] = {NUNCHUCK_REGADDR, 0x00};    
    if (i2c.write(NUNCHUCK_ADDR, (const char*)cmd, sizeof(cmd)) == I2C_ACK) {
        result = true;
    }
    return result;
}


void WiiNunchuck::read()
{
    int i;
    
    if(timer.read_ms() < 50) return;
    
    if(!WiiNunInitFlag) {
        WiiNunInitFlag = init();
    }
    
    if(WiiNunInitFlag) {
        const unsigned char cmd[] = {0x00};
        if (i2c.write(NUNCHUCK_ADDR, (const char*)cmd, sizeof(cmd)) == I2C_ACK) {
            wait(I2C_READ_DELAY);
            if (i2c.read(NUNCHUCK_ADDR, readBuf, sizeof(readBuf)) == I2C_ACK) {
                for(i = 0; i < NUNCHUCK_READLEN; ++i) {
                    readBuf[i] = (readBuf[i] ^ 0x17) + 0x17;
                }
                joyX = readBuf[Joy_X];
                joyY = readBuf[Joy_Y];
                accX = readBuf[Acc_X] << 2;
                accY = readBuf[Acc_Y] << 2;
                accZ = readBuf[Acc_Z] << 2;
                
                if(readBuf[Button] & 0x01) {
                    buttonZ = 0;
                } else {
                    buttonZ = 1;
                }
                if(readBuf[Button] & 0x02) {
                    buttonC = 0;
                } else {
                    buttonC = 1;
                }
                if(readBuf[Button] & 0x04) accX += 1;
                if(readBuf[Button] & 0x08) accX += 2;
                if(readBuf[Button] & 0x10) accY += 1;
                if(readBuf[Button] & 0x20) accY += 2;
                if(readBuf[Button] & 0x40) accZ += 1;
                if(readBuf[Button] & 0x80) accZ += 2;
           }
        }
    }
    timer.reset();
}


unsigned char WiiNunchuck::joyx()
{
    read();
    return joyX;
}


unsigned char WiiNunchuck::joyy()
{
    read();
    return joyY;
}


int WiiNunchuck::accx()
{
    read();
    return accX;
}


int WiiNunchuck::accy()
{
    read();
    return accY;
}


int WiiNunchuck::accz()
{
    read();
    return accZ;
}


bool WiiNunchuck::buttonc()
{
    read();
    return buttonC;
}


bool WiiNunchuck::buttonz()
{
    read();
    return buttonZ;
}
