#ifndef MBED_ULTRASONIC_H
#define MBED_ULTRASONIC_H

#include "mbed.h"

class Ultrasonic
{
public:
    /** initiates the class with the spcified trigger pin, echo pin, update speed and timeout **/
    Ultrasonic(PinName trigPin, PinName echoPin, float timeout = 0.1, bool repeat = false);
    
    ~Ultrasonic();
    
    // generate 10us trig signal
    void trig(void);
    
    // return distance in cm and return -1 in case of failure
    int getDistance(void);
    
    // return the echo pulse duration in us and return -1 in case of failue
    int getPulseDuration(void);
    
    // get a status whether measurement is done or not
    int getStatus(void);
    
    // clear the status that represents measurement-done.
    void clearStatus(void);
    
    // stop measuring
    void pauseMeasure(void);
    
    // set measurement mode (repeated or once)
    void setMode(bool mode);
    
    // set timeout of repeated mode
    void setTime(float time);
    
private:
    DigitalOut _trig;
    InterruptIn _echo;
    
    Timer _timer;
    Timeout _timeout;
    
    float _toVal;   // timeout value in sec, or retrig time in sec if repeat == true (반복하는 시간)
    bool _repeat;   // if true, measure repeatedly with the time interval timeout (1이면 반복, 0이면 한번)
    
    int _distance;
    int _pulseDuration;
    
    void _startT(void); // 트리거 스타트 지점
    void _endT(void);   // 트리거 종료 지점
    void _timeout_cb(void);
    
    int _done;  // end of measure
    int _cnt;   // Number of loop
    
};
#endif    