 #include "ultrasonic.h"
    
// generate a 10 us pulse to start HCSR04 ultrasonic sensor and
// enable IRQ for echo pin.
Ultrasonic::Ultrasonic(PinName trigPin, PinName echoPin, float timeout, bool repeat):\
                _trig(trigPin), _echo(echoPin), _toVal(timeout), _repeat(repeat)
{
    _timer.reset();
    _echo.rise(this, &Ultrasonic::_startT);
    _echo.fall(this, &Ultrasonic::_endT);
    _echo.disable_irq();
    _done = 0;
    _cnt = 0;
}

Ultrasonic::~Ultrasonic()
{
}

void Ultrasonic::trig(void)
{
    _done = 0;
    _echo.enable_irq();
    _trig = 1;        // trigger = 1
    wait_us(10);    // for 10 sec
    _trig = 0;        // turn off the trigger
}

int Ultrasonic::getDistance(void)
{
    if(_distance >= 0)          // if the _distance is equal or more than 0, resume that detection is completed.
        return _distance;       // return _distance.
    else                        
        return -1;              // if not, return the '-1'.
}

// return the echo pulse duration in us and return -1 in case of failure.
int Ultrasonic::getPulseDuration(void)
{
    if(_pulseDuration >= 0)     // if the _pulseDuration is equal or more than 0, resume that detection is completed.
        return _pulseDuration;  // return _pulseDuration.
    else
        return -1;              // if not, return the '-1'.
}

int Ultrasonic::getStatus(void)
{
    return _done;               // Measurement status
}

void Ultrasonic::clearStatus(void)
{
    _done = 0;
    _timer.reset();
    _echo.disable_irq();
    _cnt = 0;
    _distance = 0;                  
}

void Ultrasonic::pauseMeasure(void)
{
    _timeout.detach();             // make timeout detach to pause the measurement
}


void Ultrasonic::setMode(bool mode)
{
    _repeat = mode;             // input the value to _repeat according to the value of mode
                                // _repeat determine the way of measurement
}

void Ultrasonic::setTime(float time)
{
    _toVal = time;              // input the value to _toVal accoring to the value of time
                                // _toVal make the interrupt of _timer which is a timer object 
}

void Ultrasonic::_startT(void)
{
    _timer.start();             // read timer microseconds, this is starting time of the measurement
}

void Ultrasonic::_endT(void)
{
    _timer.stop();                          // when the pulse is falling, timer pulsetime is stopped.
    _pulseDuration = _timer.read_us();      // and the value of timer pulsetime enter the variable 'pulsedur'
    _distance = (_pulseDuration*343)/20000; // 340m/s * sec / 2(rounded) / 10000 (/u*100)
    _timer.reset();                         // After knowing the distance, time pulsetime is reseted.
    if(_repeat == true)
    {
        _timeout.attach(this, &Ultrasonic::_timeout_cb, _toVal);
        printf("%d trial: %dcm\r\n", (_cnt+1), _distance);
    }
    else
    {
        _echo.disable_irq();
        _done = 1;
        //printf("%dcm\r\n", _distance);
    }
}

void Ultrasonic::_timeout_cb(void)
{

    if(_cnt >= 9)
    {
        _echo.disable_irq();
        _done = 1;
        _cnt = 0;
    }
    else
    {
         trig();
         _cnt++;
    }
}
    