#include "mbed.h"
#include "TMP36.h"
#include "SDFileSystem.h"
#include "uLCD_4DGL.h"
#include "PinDetect.h"
#include "Speaker.h"
#include "Alien.h"
#include <vector>

//Initialize button for shooting
PinDetect pb1(p21);

//Create speaker object
Speaker mySpeaker(p21);

using namespace std;

//Variables
bool addBullet = false;
int bul = 0;
int numAliens = 5;

//Interupt function for the shooting button
void pb1_hit_callback (void)
{
    addBullet = true;
}

int main()
{
    //Sets up speaker object
    Speaker mySpeaker(p25);
    //Sets start time of the game
    time_t startTime = time(0);

    //Set up interrupts
    pb1.mode(PullUp);
    // Delay for initial pullup to take effect
    wait(0.3);
    // Setup Interrupt callback functions for a pb hit
    pb1.attach_deasserted(&pb1_hit_callback);
    // Start sampling pb inputs using interrupts
    wait(0.3);
    pb1.setSampleFrequency();
    // pushbuttons now setup and running

    srand(time(0));
    
    vector<ScreenObject *> pieces(7); //Create an STL vector of pointers
    
    //Initialize aliens randomly from each type in random positions
    for (int i = 0; i <= 5; i++) {
        int posX = (20 + rand() % 80);
        int posY = 12*i+10;
        //(new AlienAlice(posX, posY))->draw();
        int type = (rand() % 4 );
        if(type == 0)
            pieces[i] = (new AlienAlice(posX, posY));
        else if(type == 1)
            pieces[i] = (new AlienBob(posX, posY));
        else if(type == 2)
            pieces[i] = (new AlienOne(posX, posY));
        else if(type == 3)
            pieces[i] = (new AlienTwo(posX, posY));
        //pieces[i]->draw();
    }
    
    //Initialize the ship
    pieces[6] = (new Ship(50));
    pieces[6]->draw();
    
    //Initialize the LCD
    pieces[0]->initialize();
    
    bool won = false;
    int inc = 0;
    
    //Loop while playing
    while(won == false) {
        
        //Update the alien positions
        for (int i = 0; i <= numAliens; i++) {
            pieces[i]->clear();
            pieces[i]->update(4);
        }
        
        //Update the ship's position
        pieces[numAliens+1]->clear();
        pieces[numAliens+1]->update(0);
        
        //If a bullet has been trigger and is allowed initialize it
        if(addBullet == 1) {
            bul = 1;
            //addBullet = true;
            if(inc == 1)
                pieces[numAliens + 2]->clear();
            inc = 1;
            pieces[numAliens + 2] = (new Bullet(pieces[numAliens + 1]->getPosX(), 119));
            //pieces[7]->clear();
            //pieces[6]->draw();
            addBullet = 0;
        }
        
        //Check if bullet is in same space as an alien and remove both if that is the case
        if(bul == 1) {
            pieces[numAliens + 2]->clear();
            pieces[numAliens + 2]->update(0);
            for (int i = 0; i < (pieces.size() - 1); i++) {
                if((((pieces[numAliens + 2]->getPosX()+15) > pieces[i]->getPosX() && (pieces[numAliens + 2]->getPosX()+10) < (pieces[i]->getPosX() + 12)) && ((pieces[numAliens + 2]->getPosY()-8) < (pieces[i]->getPosY()+12) && (pieces[numAliens + 2]->getPosY()) > (pieces[i]->getPosY())))) {
                    pieces[numAliens + 2]->clear();
                    pieces[i]->clear();
                    pieces.erase(pieces.begin() + i);
                    numAliens -= 1;
                    bul = 0;
                    mySpeaker.PlayNote(300.0,0.1,0.025);
                }
            }
            
            //End game if all the aliens are gone
            if(numAliens == -1) {
                time_t endTime = time(0)-startTime;
                pieces[numAliens + 1]->end(endTime);
                won = true;
                for(int j = 0; j < 3; j++) {
                    mySpeaker.PlayNote(300.0,0.1,0.025);
                    mySpeaker.PlayNote(400.0,0.1,0.025);
                }
            }
        }
    }
    
    //Loop eternally after winning
    while(1) {
    }
}