#ifndef ALIEN
#define ALIEN

#include "mbed.h"

//Base class all graphical objects derive from
class ScreenObject
{
public:
    virtual void draw() = 0;
    virtual void update(int) = 0;
    virtual void clear() = 0; 
    virtual int getPosX() = 0;
    virtual int getPosY() = 0;
    int getNumAliens() {return(numAliens);};
    void setNumAliens(int num) {numAliens = num;};
    void initialize();
    void end(int endTime);
    
private:
    int numAliens;
};

//Class for the Alice Alien
class AlienAlice: public ScreenObject
{
public:
    AlienAlice() {posAliceAlienX = 0; posAliceAlienY = 0;};
    AlienAlice(int posX, int posY) {posAliceAlienX = posX; posAliceAlienY = posY; left = false;};
    void draw();
    void update(int);
    void clear();
    int getPosX() {return(posAliceAlienX);};
    int getPosY() {return(posAliceAlienY);};
private:
    int posAliceAlienX;
    int posAliceAlienY;
    bool left;
};

//Class for the first added alien
class AlienOne: public ScreenObject
{
public:
    AlienOne() {posOneAlienX = 0; posOneAlienY = 0;};
    AlienOne(int posX, int posY) {posOneAlienX = posX; posOneAlienY = posY; left = false;};
    void draw();
    void update(int);
    void clear();
    int getPosX() {return(posOneAlienX);};
    int getPosY() {return(posOneAlienY);};
private:
    int posOneAlienX;
    int posOneAlienY;
    bool left;
};


//Class for the second added alien
class AlienTwo: public ScreenObject
{
public:
    AlienTwo() {posTwoAlienX = 0; posTwoAlienY = 0;};
    AlienTwo(int posX, int posY) {posTwoAlienX = posX; posTwoAlienY = posY; left = false;};
    void draw();
    void update(int);
    void clear();
    int getPosX() {return(posTwoAlienX);};
    int getPosY() {return(posTwoAlienY);};
private:
    int posTwoAlienX;
    int posTwoAlienY;
    bool left;
};


//Class for the first Alien Bob
class AlienBob: public ScreenObject
{
public:
    AlienBob() {posBobAlienX = 0; posBobAlienY = 0;}
    AlienBob(int posX, int posY) {posBobAlienX = posX; posBobAlienY = posY; upDown = false; left = false;};
    void draw();
    void update(int);
    void clear();
    int getPosX() {return(posBobAlienX);}
    int getPosY() {return(posBobAlienY);};
private:
    int posBobAlienX;
    int posBobAlienY;
    bool upDown;
    bool left;
};

//Class for the ship object
class Ship: public ScreenObject
{
public:
    Ship(int) {posShipX = 50; posShipY = 120;};
    void draw();
    void update(int);
    void clear();
    int getPosX();
    int getPosY() {return(posShipY);};
private:
    int posShipX;
    int posShipY;
};

//Class for the bullet shot from the ship
class Bullet: public ScreenObject
{
public:
    Bullet(int posX, int posY) {posBulletX = posX; posBulletY = posY;};
    void draw();
    void update(int);
    void clear();
    int getPosX() {return(posBulletX);};
    int getPosY() {return(posBulletY);};
private:
    int posBulletX;
    int posBulletY;
    bool isBullet;
    bool addBullet;
};

#endif