#include "Alien.h"
#include "uLCD_4DGL.h"
#include "MMA8452.h"

#define ALIEN_HEIGHT   8
#define ALIEN_WIDTH  11
#define _ 0x000000  //BLACK  
#define X 0xFFFFFF   //WHITE 


//Spite implementation for all of the aliens
int alienBobDown_sprite[ALIEN_HEIGHT * ALIEN_WIDTH] = {
    _,_,X,_,_,_,_,_,X,_,_,
    _,_,_,X,_,_,_,X,_,_,_,
    _,_,X,X,X,X,X,X,X,_,_,
    _,X,X,_,X,X,X,_,X,X,_,
    X,X,X,X,X,X,X,X,X,X,X,
    X,_,X,X,X,X,X,X,X,_,X,
    X,_,X,_,_,_,_,_,X,_,X,
    _,_,_,X,X,_,X,X,_,_,_,
};

int alienBobUp_sprite[ALIEN_HEIGHT * ALIEN_WIDTH] = {
    _,_,X,_,_,_,_,_,X,_,_,
    X,_,_,X,_,_,_,X,_,_,X,
    X,_,X,X,X,X,X,X,X,_,X,
    X,X,X,_,X,X,X,_,X,X,X,
    X,X,X,X,X,X,X,X,X,X,X,
    _,_,X,X,X,X,X,X,X,_,_,
    _,_,X,_,_,_,_,_,X,_,_,
    _,X,_,_,_,_,_,_,_,X,_,
};

int alienAlice_sprite[ALIEN_HEIGHT * ALIEN_WIDTH] = {
    _,_,_,_,X,X,X,_,_,_,_,
    _,X,X,X,X,X,X,X,X,X,_,
    X,X,X,X,X,X,X,X,X,X,X,
    X,X,X,_,_,X,_,_,X,X,X,
    X,X,X,X,X,X,X,X,X,X,X,
    _,_,_,X,X,_,X,X,_,_,_,
    _,_,X,X,_,_,_,X,X,_,_,
    X,X,_,_,_,X,_,_,_,X,X,
};

int alienOne_sprite[ALIEN_HEIGHT * ALIEN_WIDTH] = {
    _,_,_,_,_,X,_,_,_,_,_,
    _,_,_,X,X,X,X,X,_,_,_,
    _,_,X,X,X,X,X,X,X,_,_,
    X,X,X,_,X,X,X,_,X,X,X,
    X,X,X,X,X,X,X,X,X,X,X,
    _,_,_,X,X,X,X,X,X,_,_,
    _,_,X,X,X,X,X,X,X,_,_,
    X,X,_,_,X,X,X,_,_,X,X,
};

int alienTwo_sprite[ALIEN_HEIGHT * ALIEN_WIDTH] = {
    _,_,_,X,X,X,X,X,_,_,_,
    _,_,X,X,X,X,X,X,X,_,_,
    _,X,X,X,X,X,X,X,X,X,_,
    X,X,X,_,_,X,_,_,X,X,X,
    X,X,X,X,X,X,X,X,X,X,X,
    _,X,X,X,X,X,X,X,X,X,_,
    _,_,X,X,X,X,X,X,X,_,_,
    X,X,_,_,_,X,_,_,_,X,X,
};


//Creation of LCD object 
uLCD_4DGL uLCD(p9, p10, p11);

//Accelerometer setup
Serial pc(USBTX,USBRX);
MMA8452 acc(p28, p27, 40000);

void AlienAlice::draw()
{
    uLCD.BLIT(posAliceAlienX, posAliceAlienY, ALIEN_WIDTH, ALIEN_HEIGHT, alienAlice_sprite); //Draws the alien on the LCD
}

//Updates the position of the alien and calls the draw function
void AlienAlice::update(int posX)
{
    posX += 2;
    if ((posAliceAlienX + posX) > 100)
        left = true;

    if(left == false)
        posAliceAlienX += posX;
    else {
        posAliceAlienX -= posX;
        if (posAliceAlienX < 20)
            left = false;
    }
    draw();
}

//Clears the alien from the LCD
void AlienAlice::clear()
{
    uLCD.filled_rectangle(posAliceAlienX, (posAliceAlienY), posAliceAlienX+12, posAliceAlienY+8, BLACK);
    wait(.02);
}

//Draws Alien One
void AlienOne::draw()
{
    uLCD.BLIT(posOneAlienX, posOneAlienY, ALIEN_WIDTH, ALIEN_HEIGHT, alienOne_sprite);
}

//Updates the position of Alien One and calls draw
void AlienOne::update(int posX)
{
    if ((posOneAlienX + posX) > 100)
        left = true;

    if(left == false)
        posOneAlienX += posX;
    else {
        posOneAlienX -= posX;
        if (posOneAlienX < 20)
            left = false;
    }
    draw();
}

//Clears alien One from the LCD
void AlienOne::clear()
{
    uLCD.filled_rectangle(posOneAlienX, (posOneAlienY), posOneAlienX+12, posOneAlienY+12, BLACK);
    wait(.02);
}

//Draws Alien Two
void AlienTwo::draw()
{
    uLCD.BLIT(posTwoAlienX, posTwoAlienY, ALIEN_WIDTH, ALIEN_HEIGHT, alienTwo_sprite);
}

//Updates the position of Alien Two and calls draw
void AlienTwo::update(int posX)
{
    if ((posTwoAlienX + posX) > 100)
        left = true;

    if(left == false)
        posTwoAlienX += posX;
    else {
        posTwoAlienX -= posX;
        if (posTwoAlienX < 20)
            left = false;
    }
    draw();
}

//Clears Alien Two from the Screen
void AlienTwo::clear()
{
    uLCD.filled_rectangle(posTwoAlienX, (posTwoAlienY), posTwoAlienX+12, posTwoAlienY+12, BLACK);
    wait(.02);
}

//Calculates time spent playing game and displays it
void ScreenObject::end(int endTime)
{
    uLCD.printf("\n\n\n\n Congratulations!!\n\n    Earth Saved!\n\n\n    (%d Seconds)",endTime);
}

//Initializes LCD
void ScreenObject::initialize()
{
    uLCD.baudrate(300000);
    wait(0.3);
}

//Clears the Bob alien from the LCD
void AlienBob::clear()
{
    //wait(.1);
    uLCD.filled_rectangle(posBobAlienX, (posBobAlienY), posBobAlienX+12, (posBobAlienY+12), BLACK);
    wait(.02);
}

//Draws the Bob alien
void AlienBob::draw()
{
    if(upDown == true)
        uLCD.BLIT(posBobAlienX, posBobAlienY, ALIEN_WIDTH, ALIEN_HEIGHT, alienBobUp_sprite);
    else
        uLCD.BLIT(posBobAlienX, posBobAlienY, ALIEN_WIDTH, ALIEN_HEIGHT, alienBobDown_sprite);
}

//Updates the position of the Bob alien on the LCD
void AlienBob::update(int posX)
{
    if (upDown == false) {
        upDown = true;
    } else {
        upDown = false;
    }

    if ((posBobAlienX + posX) > 100)
        left = true;

    if(left == false)
        posBobAlienX += posX;
    else {
        posBobAlienX -= posX;
        if (posBobAlienX < 20)
            left = false;
    }
    //posBobAlienY = posY;
    draw();
}

//Draw the ship on the LCD
void Ship::draw()
{
    uLCD.filled_rectangle(posShipX, posShipY + 10, posShipX + 25, posShipY, WHITE);
}

//Updates the position of the ship based on accelerometer data and calls draw
void Ship::update(int posX)
{

    double x;
    double y;
    double z;
    acc.setBitDepth(MMA8452::BIT_DEPTH_12);
    acc.setDynamicRange(MMA8452::DYNAMIC_RANGE_4G);
    acc.setDataRate(MMA8452::RATE_100);
    while(!acc.isXYZReady()) {
        wait(.02);
    }
    acc.readXYZGravity(&x,&y,&z);
    if(x > 0.5) {
        if((posShipX < 105)) {
            posShipX += 4;
        }
    } else if(x < -0.5) {
        if((posShipX > 5)) {
        posShipX -= 4;
        }
    }
    draw();
}

int Ship::getPosX()
{
    return(posShipX);
}

//Clears the ship from the LCD
void Ship::clear()
{
    uLCD.filled_rectangle(posShipX, posShipY + 10, posShipX + 25, posShipY, BLACK);
}

//Clears the bullet from the LCD
void Bullet::clear()
{
    uLCD.filled_rectangle(posBulletX + 10, posBulletY, posBulletX + 15, posBulletY - 8, BLACK);
}

//Updates the Bullet's position and calls draw if not off the screen
void Bullet::update(int posX)
{
    posBulletY -= 5;
    if(posBulletY < 0)
        clear();
    else
        draw();
}

//Draws the bullet
void Bullet::draw()
{
    uLCD.filled_rectangle(posBulletX + 10, posBulletY, posBulletX + 15, posBulletY - 8, WHITE);
}
