#include "mbed.h"
#include "ATParser.h"
#include "TSL2561.h"
#include "MPL3115A2.h"
#include <string>
#include <algorithm>
#include <iostream>





BufferedSerial pc(SERIAL_TX, SERIAL_RX);
BufferedSerial dev(PA_9, PA_10);
DigitalOut myled(LED1);
MPL3115A2 pressure_sensor(PB_7,PB_6,0x60);



int main() {
    char s;
    pc.baud(115200);
    dev.baud(115200);
    
    ATParser at = ATParser(dev, "\r\n");
    
    printf("Program Started\n\r");
    while(1) {
       s = pc.getc();
       pc.putc(s);
        
    
        pc.printf("\n\rConnecting Lora\n\r");
        if (at.send("AT")) {
           if(at.recv("OK")){
           pc.printf("Lora Device Working\r\n");
           }
           else {
            pc.printf("Lora Device NOT Working\r\n");
           }
        }
        if (at.send("AT+NI=1,MTCDT-19400691")) {
           if(at.recv("OK")){
           pc.printf("Network ID Working\r\n");
           }
           else {
            pc.printf("Network ID NOT Working\r\n");
           }
        }
        if (at.send("AT+NK=1,MTCDT-19400691")) {
           if(at.recv("OK")){
           pc.printf("Network Key Working\r\n");
           }
           else {
            pc.printf("Network Key NOT Working\r\n");
           }
        }
        if (at.send("AT+FSB=1")) {
           if(at.recv("OK")){
           pc.printf("Frequency Sub Band set to 1\r\n");
           }
           else {
            pc.printf("Frequency Sub Band NOT set\r\n");
           }
        }
        if (at.send("AT+JOIN")) {
           if(at.recv("OK")){
           pc.printf("Successfully joined network\r\n");
           }
           else {
            pc.printf("ERROR Unable to join Network\r\n");
           }
        }
        if (s == 's') {
            float temp = pressure_sensor.getTemperature();
            float pres = pressure_sensor.getAltitude();
            pc.printf("%f %f\n\r", temp, pres);
            at.send("AT+SEND=%3.2f %3.2f");  
        }
            
    while(1) {
        float temp = pressure_sensor.getTemperature();
        float pres = pressure_sensor.getAltitude();
        pc.printf("%f %f\n\r", temp, pres);
        at.send("AT+SEND=%3.2f %3.2f", temp, pres);  
        wait(3600); 
    }
}
}