#include "mbed.h"
#include "ATParser.h"
#include "TSL2561.h"
#include <string>
#include <algorithm>
#include <iostream>





BufferedSerial pc(SERIAL_TX, SERIAL_RX);
BufferedSerial dev(PA_9, PA_10);
DigitalOut myled(LED1);
TSL2561 light_sensor(PB_7, PB_6); 



int main() {
    pc.baud(115200);
    dev.baud(115200);
    
    ATParser at = ATParser(dev, "\r\n");
    
    printf("Program Started\n\r");
    
        pc.printf("\n\rConnecting Lora\n\r");
        if (at.send("AT")) {
           if(at.recv("OK")){
           pc.printf("Lora Device Working\r\n");
           }
           else {
            pc.printf("Lora Device NOT Working\r\n");
           }
        }
        if (at.send("AT+NI=1,MTCDT-19400691")) {
           if(at.recv("OK")){
           pc.printf("Network ID Working\r\n");
           }
           else {
            pc.printf("Network ID NOT Working\r\n");
           }
        }
        if (at.send("AT+NK=1,MTCDT-19400691")) {
           if(at.recv("OK")){
           pc.printf("Network Key Working\r\n");
           }
           else {
            pc.printf("Network Key NOT Working\r\n");
           }
        }
        if (at.send("AT+FSB=1")) {
           if(at.recv("OK")){
           pc.printf("Frequency Sub Band set to 1\r\n");
           }
           else {
            pc.printf("Frequency Sub Band NOT set\r\n");
           }
        }
        if (at.send("AT+JOIN")) {
           if(at.recv("OK")){
           pc.printf("Successfully joined network\r\n");
           }
           else {
            pc.printf("ERROR Unable to join Network\r\n");
           }
        }
    int i = 0;
    while(1) {
        float data[24];
        if(i == 24) {
            char dataS[3200];
            sprintf(dataS, "%3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f", data[0], data[1], data[2], data[3], data[4], data[5], data[6], data[7], data[8], data[9], data[10], data[11], data[12], data[13], data[14], data[15], data[16], data[17], data[18], data[19], data[20], data[21], data[22], data[23]);
            at.send("AT+SEND=\"%s\"", dataS);  
            i = 0;
        }
        float light = light_sensor.lux();
        data[i] = light;
        pc.printf("%f\n\r", data[i]);
        i++;
        wait(3600); 
    }
}