#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"

Mutex lcd_mutex;
uLCD_4DGL lcd(p28, p27, p30);
PwmOut red(p22);
PwmOut green(p23);
PwmOut blue(p24);
DigitalOut led4(LED4);

class Speaker
{
public:
    Speaker(PinName pin) : _pin(pin) {
// _pin(pin) means pass pin to the Speaker Constructor
    }
// class method to play a note based on PwmOut class
    void PlayNote(float frequency, float duration, float volume) {
        _pin.period(1.0/frequency);
        _pin = volume/2.0;
        wait(duration);
        _pin = 0.0;
    }
 
private:
// sets up specified pin for PWM using PwmOut class 
    PwmOut _pin;
};

// Thread 1
// control RGB LED
void thread1(void const *args)
{
    while(true) {       
        red = 1;
        wait(0.5);
        red = 0;
        blue = 1;
        wait(0.5);
        blue = 0;
        Thread::wait(50);
    }
}

// Thread 2 control uLCD image
void thread2(void const *args)
{
    lcd_mutex.lock();
    lcd.cls();
    lcd.media_init();
    lcd.set_sector_address(0x003B, 0x9000);
    lcd.display_image(0,0);
    lcd_mutex.unlock();
    Thread::wait(5000);
}

// Thread 3 control speaker
void thread3(void const *args)
{
    Speaker mySpeaker(p21);
    while(1){
        mySpeaker.PlayNote(783.991,1.0,0.05);
        mySpeaker.PlayNote(587.330,1.0,0.05);
        Thread::wait(50);
    }
}

// Thread 4 control uLCD text
void thread4(void const *args)
{
    lcd_mutex.lock();
    lcd.locate(7,13);
    lcd.printf("HALT!");
    lcd_mutex.unlock();
    Thread::wait(1000);
}

int main()
{
    Thread t1(thread1); //start thread1
    Thread t2(thread2); //start thread2
    Thread t3(thread3); //start thread3
    Thread t4(thread4); //start thread4
    while(1) {
        led4 = !led4;
        Thread::wait(1000);
    }
}
