#include "mbed.h"
#include "rtos.h"
#include <stdio.h>

I2C i2c(PB_7, PB_6);
DigitalOut led_1(LED1);
AnalogIn heaterInput_pin(A2);
Serial pc(SERIAL_TX, SERIAL_RX);
const int ADDR = 0x80;

void blink()
{
    led_1 = !led_1;
}
    
void blink_thread(void const *argument)
{
    while (true){
        Thread::wait(500);
        blink();
    }
}

int X0,X1,Y0,Y1,Y2,Y3;
double X,Y,X_out,Y_out1,Y_out2;
       
void
i2cHandler()
{
    char cmd[2];
  pc.printf("\r\nStart getTempRH\r\n");
    //while (1) {
        cmd[0] = 0xE3;
        cmd[1] = 0x00;
        i2c.write(ADDR, cmd, 1);
        wait(0.1);
        cmd[0] = 0x00;
        i2c.write(ADDR, cmd, 0);
        i2c.read(ADDR, cmd, 2);

  X0 = cmd[0];
  X0 = X0 << 8;
  X1 = cmd[1];
  X_out = X0+X1;
  /**Calculate and display temperature**/
  X=(175.72*X_out)/65536;                        
  X=X-46.85;
  pc.printf("T:%f,\r\n",X); 
 
        wait(0.1);
        
        cmd[0] = 0xE5;
        cmd[1] = 0x00;
        i2c.write(ADDR, cmd, 1);
 
        wait(0.1);
 
        cmd[0] = 0x00;
        i2c.write(ADDR, cmd, 0);
        i2c.read(ADDR, cmd, 2);
  Y0 = cmd[0];
  Y2 = Y0/100;
  Y0 = Y0%100;
  Y1 = cmd[1];
  Y_out1 = Y2*25600;
  Y_out2 = Y0*256+Y1;
     
  /**Calculate and display relative humidity**/
  Y_out1 = (125*Y_out1)/65536;                     
  Y_out2 = (125*Y_out2)/65536;
  Y = Y_out1+Y_out2;
  Y=Y-6;
  pc.printf("Rh:%f}\r\n",Y);
 
        wait(0.1);
        
        //float tmp = (float((cmd[0]<<8)|cmd[1]) / 256.0);
        //printf("Temp = %.2f\n", tmp);
    //}
}

void i2c_thread(void const *argument)
{
    while (true){
        Thread::wait(500);
        i2cHandler();
    }
}
     
int main() {
  pc.baud(115200);
  Thread doi2c(i2c_thread, NULL, osPriorityLow, DEFAULT_STACK_SIZE);
  Thread blinkLED(blink_thread, NULL, osPriorityLow, DEFAULT_STACK_SIZE);

  while(1) 
  {
    Thread::wait(10);
  }
}
