/* Masa Kovacevic
* 2020/0229
* ETF Beograd
*/



// Uvoz biblioteka
#include "mbed.h"



// Definisanje makroa
#define SCALE 2900
#define WAIT 2


//Globalne promenljive
AnalogIn pot2(PA_1);
AnalogIn pot1(PA_0);
PwmOut buzz(PA_11);
int sound_intensity;
int sound_intensity_first_digit;
int sound_intensity_second_digit;
InterruptIn sw1(PC_9);
DigitalOut SEL2(PC_7); 
DigitalOut SEL1(PB_6);
DigitalIn SW1(PC_9);
BusOut display(PA_10,PA_9,PA_8,PB_10,PB_5,PB_4,PB_3,PA_5);


//Prototipi funkcija
void ISR_sw1(void);
void Funkcija2 (int second_digit);  
void Funkcija1 (int first_digit); 
int convert (int digit);



//Glavna funkcija
int main()
{
   sw1.fall(&ISR_sw1);
   while(1)
   {
    buzz.period_us(pot1.read()*SCALE + 100);
    buzz.write(pot2.read());
    wait_ms(WAIT);
    sound_intensity = pot2.read()*100;
    sound_intensity_first_digit = sound_intensity/10;
    sound_intensity_second_digit = sound_intensity%10;
    
    }
}

void Funkcija2 (int second_digit){

        SEL2.write(0);
        display = convert(second_digit);
        wait_ms(20);
        SEL2.write(1);
        
    }
 
    
void Funkcija1 (int first_digit){
        
        SEL1.write(0);
        display = convert(first_digit); 
        wait_ms(20);
        SEL1.write(1);
  } 
  
int convert (int digit) {

   int d;

   switch(digit) {
      case 0 :
         d = 0xC0;
         break;
      case 1:
         d = 0xF9;
      case 2 :
         d = 0xA4;
         break;
      case 3 :
         d= 0xB0;
         break;
      case 4 :
         d = 0x99;
         break;
      case 5 :
         d = 0x92;
         break;
      case 6 :
         d = 0x82;
         break;
      case 7 :
         d = 0xF8;
         break;
      case 8 :
         d = 0x80;
         break;
      case 9 :
         d = 0x90;
         break;
    }
    
   return d;
}
void ISR_sw1()
{
    if (sound_intensity_first_digit != 0)
    {
        Funkcija1(sound_intensity_first_digit);
        Funkcija2(sound_intensity_first_digit);
    }
    else 
    {
        Funkcija2(sound_intensity_first_digit);
    }
}