// Masa Kovacevic  2020/0229
// Decembar 2021

#include "Adafruit_GFX.h"
#include "Adafruit_GFX_Config.h"
#include "Adafruit_SSD1306.h"

#include "mbed.h"
#include "mb_pins.h"
#include "platform/mbed_thread.h"
#include "MQTTClientMbedOs.h"

#define I2C_ADDRESS 0x3c<<1
#define OLED_HEIGHT_PX 64
#define OLED_WIDTH_PX 128
#define I2C_FREQUENCY 400000


// Scaler to 3v3L
#define VOLTAGE_SCALER                                                      3.3f
// Client yield timeout in miliseconds:
#define YIELD_TIMEOUT_MS                                                    1000
// Maximum number of networks to scan for:
#define MAX_NETWORKS                                                          15
// Small delay for network information printing:
#define PRINTF_DELAY_MS                                                       10


// Left potentiometer:
AnalogIn pot1(MB_POT1);
// Left button on the motherboard:
InterruptIn sw1(MB_SW1);
// Pointer to a WiFi network object:
WiFiInterface *wifi;
// Creating TCP socket:
TCPSocket socket;
// Creating MQTT client using the TCP socket;
MQTTClient client(&socket);
// Message handler:
MQTT::Message message;

I2C i2c(PB_14, PB_13);
Adafruit_SSD1306_I2c myOled(i2c,PB_5,I2C_ADDRESS,OLED_HEIGHT_PX,OLED_WIDTH_PX);


// Strings for start and stop
char str11[] = "start";
char str22[] = "stop";
// Indicator of start and stop:
int start;
int stop;
// Topic and subscription:
char* topic = "pubpim";
char* topic_sub = "subpim";
// Counter of arrived messages:
int arrivedcount = 0;
// Flag indicating that button is not pressed:
int button_pressed=0;
// HiveMQ broker connectivity information:
const char* hostname = "broker.hivemq.com";
int port = 1883;
// Returning a string for a provided network encryption: 
const char *sec2str(nsapi_security_t sec)
{
    switch (sec) 
    {
        case NSAPI_SECURITY_NONE:
            return "None";
        case NSAPI_SECURITY_WEP:
            return "WEP";
        case NSAPI_SECURITY_WPA:
            return "WPA";
        case NSAPI_SECURITY_WPA2:
            return "WPA2";
        case NSAPI_SECURITY_WPA_WPA2:
            return "WPA/WPA2";
        case NSAPI_SECURITY_UNKNOWN:
        default:
            return "Unknown";
    }
}

int scan_networks(WiFiInterface *wifi)
{
    printf("Scan:\n");
    
    // Scan only for the number of networks, first parameter is NULL:
    int count = wifi->scan(NULL, 0);
    // If there are no networks, count == 0, if there is an error, counter < 0:
    if (count <= 0)
    {
        printf("scan() failed with return value: %d\n", count);
        return 0;
    }

    // Limit number of network arbitrary to some reasonable number:
    count = count < MAX_NETWORKS ? count : MAX_NETWORKS;
    
    // Create a local pointer to an object, which is an array of WiFi APs:
    WiFiAccessPoint *ap = new WiFiAccessPoint[count];
    // Now scan again for 'count' networks and populate the array of APs:
    count = wifi->scan(ap, count);
    
    // This time, the number of entries to 'ap' is returned:
    if (count <= 0) 
    {
        printf("scan() failed with return value: %d\n", count);
        return 0;
    }
    
    // Print out the parameters of each AP:
    for (int i = 0; i < count; i++) 
    {
        printf("Network: %s secured: %s BSSID: %hhX:%hhX:%hhX:%hhx:%hhx:%hhx RSSI: %hhd Ch: %hhd\n", ap[i].get_ssid(),
               sec2str(ap[i].get_security()), ap[i].get_bssid()[0], ap[i].get_bssid()[1], ap[i].get_bssid()[2],
               ap[i].get_bssid()[3], ap[i].get_bssid()[4], ap[i].get_bssid()[5], ap[i].get_rssi(), ap[i].get_channel());
        thread_sleep_for(PRINTF_DELAY_MS);
    }
    printf("%d networks available.\n", count);
    
    // Since 'ap' is dynamically allocated pointer to the array of objects, it
    // needs to be deleted:
    delete[] ap;
    return count;
}

// Comparing strings
bool compare_start(char *str1, char *str2)
{
    for (int i = 0, i < 6, i++){
    
        if (*str1 == *str2 && *str1 == '\0' && *str2 == '\0'){
        return true;
        str1++;
        str2++;
        }
    }      
  
    return false;
}

bool compare_stop(char *str1, char *str2)
{
    for (int i = 0, i < 5, i++){
    
        if (*str1 == *str2 && *str1 == '\0' && *str2 == '\0'){
        return true;
        str1++;
        str2++;
        }
    }      
  
    return false;
}

void messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    //printf("Message arrived: qos %d, retained %d, dup %d, packetid %d\r\n", message.qos, message.retained, message.dup, message.id);
    printf("Message from the browser: %.*s\r\n", message.payloadlen, (char*)message.payload);
    ++arrivedcount;
    
    
    myOled.clearDisplay();
    myOled.printf("%.*s \r", message.payloadlen, (char*)message.payload);
    myOled.display();
}



int main()
{
    
    
    
    // Create a default network interface:
    wifi = WiFiInterface::get_default_instance();
    if (!wifi) {
        printf("ERROR: No WiFiInterface found.\n");
        return -1;
    }
    
    // Scan for available networks and aquire information about Access Points:
    int count = scan_networks(wifi);
    if (count == 0) {
        printf("No WIFI APs found - can't continue further.\n");
        return -1;
    }
    
    // Connect to the network with the parameters specified in 'mbed_app.json':
    printf("\nConnecting to %s...\n", MBED_CONF_APP_WIFI_SSID);
    int ret = wifi->connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2);
    if (ret != 0) {
        printf("\nConnection error: %d\n", ret);
        return -1;
    }
    
    
    // Open TCP socket using WiFi network interface:
    socket.open(wifi);
    // Connect to the HiveMQ broker:
    socket.connect(hostname, port);
    // Fill connect data with default values:
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    // Change only ID and protocol version:
    data.MQTTVersion = 3;
    data.clientID.cstring = "NUCLEO-L476RG-60";
    
    client.connect(data);
    client.subscribe(topic_sub, MQTT::QOS0, messageArrived);
      
    while (true) {
        myOLED.begin(); 
        i2c_obj.frequency(I2C_FREQUENCY); 
        myOled.clearDisplay();
        myOled.display();
        
        while (start) {

            char buf[100];
            sprintf(buf, "V(POT1) = %1.2f\r\n", pot1*VOLTAGE_SCALER);
            message.qos = MQTT::QOS0;
            message.retained = false;
            message.dup = false;
            message.payload = (void*)buf;
            message.payloadlen = strlen(buf)+1;
            client.publish(topic, message);
            thread_sleep_for(PRINTF_DELAY_MS);
            
        }
        
        
        // Need to call yield API to maintain connection:
        client.yield(YIELD_TIMEOUT_MS);
    }
}