 
/*
 * Biblioteke za uvoz:
 */
#include "mbed.h"
 
/*
 * Definisanje makroa:
 */
 
/*
 * Globalne promenljive:
 */
BusOut display(PA_10,PA_9,PA_8,PB_10,PB_5,PB_4,PB_3,PA_5);

DigitalOut SEL2(PC_7); 
DigitalOut SEL1(PB_6);
DigitalIn SW1(PC_9);

/*
 * Deklaracija funkcija:
 */
 void Funkcija2 (int i);  //funkcija za digit 1
 void Funkcija1 (int k);  //funkcija za digit 2
 void Funkcija0 (void);  //funkcija kada elim da mi digit 1 bude 0
 int convert (int broj);
/*
 * Glavna funkcija:
 */
int main()
{   
    static char ButtonReleased = 0;
    
    
    while(true)
    { 
        int i = 0;  
        int k = 0;
        while (i <= 9){ //ispis prvih 9 cifara
            if (!SW1)
            {
                if ( ButtonReleased){
                    Funkcija2(i);
                }    ButtonReleased = 0;
            }
            else 
            {
                ButtonReleased = 1;
            }
            wait_ms(50); 
            i = i+1;
        } 
        
        
        while (k <= 5) //ispis posledljih 6 brojva
        {
              if (!SW1)
              {
                if (ButtonReleased)
                {
                    SEL2.write(0);
                    display = 0xF9; 
                    wait_ms(15);
                    SEL2.write(1);
                    Funkcija1(k);
                    ButtonReleased = 0;
                }
              }
            
              else 
              {
                    ButtonReleased = 1;
              }
                
              wait_ms(50); 
              k = k+1;
        } 
    }
        
        Funkcija0();
}
 
/*
 * Definicija funkcija:
 */  
 
 
void Funkcija2 (int i){

        SEL2.write(0);
        display = convert(i);
        wait_ms(15);
        SEL2.write(1);
        
    }
 
    
void Funkcija1 (int k){
        
        SEL1.write(0);
        display = convert(k); 
        wait_ms(15);
        SEL1.write(1);
  } 

void Funkcija0(){
        SEL2.write(0);
        display = 0xC0; 
        wait_ms(15);
        SEL2.write(1);
}

int convert (int broj) {

   int d;

   switch(broj) {
      case 0 :
         d = 0xC0;
         break;
      case 1:
         d = 0xF9;
      case 2 :
         d = 0xA4;
         break;
      case 3 :
         d= 0xB0;
         break;
      case 4 :
         d = 0x99;
         break;
      case 5 :
         d = 0x92;
         break;
      case 6 :
         d = 0x82;
         break;
      case 7 :
         d = 0xF8;
         break;
      case 8 :
         d = 0x80;
         break;
      case 9 :
         d = 0x90;
         break;
    }
    
   return d;
}
