/**
 
Author: Kevin Lin
Title: Lab 4
Date: October 22 2021
Description: Main function that implements the FarkleGame and its dice.
 
**/
#include "die.h"
#include "farklegame.h"
#include "PinDetect.h"
 
#include "mbed.h"
 
using namespace std;
 
Serial pc(USBTX,USBRX);
Speaker mySpeaker(p21);


 
int main(){
    
    //clear system
    system("clear");
    
    //declare buttons

    
    //declare uLCD screen
    uLCD_4DGL uLCD(p9,p10,p11);
    uLCD.cls();
    uLCD.display_control(PORTRAIT);
    PinDetect Button1(p16);
    PinDetect Button2(p17);
    Button1.mode(PullUp);
    Button2.mode(PullUp);
    
    //declare accelerometer
    MMA8452 acc(p28, p27, 40000);
    acc.setBitDepth(MMA8452::BIT_DEPTH_12);
    acc.setDynamicRange(MMA8452::DYNAMIC_RANGE_4G);
    acc.setDataRate(MMA8452::RATE_100);
    
    int numDice = 6;
    
    FarkleGame game;
    
    while(1){
        game.displayIntro(uLCD, numDice);
        game.restart();
        
        while(!game.enoughGravity(acc)){   
            if(!Button2){
                numDice = (numDice+1)%7;
                game.displayIntro(uLCD,numDice);
            }        
        }
        
        while(Button1){
            if(game.enoughGravity(acc)){
                //roll dice and displar
                game.rollDice(mySpeaker);
                game.displayDice(uLCD, numDice);
                
                //update scores
                game.loadVals(numDice);
                game.changeScore();
                
                //display screens based on scores
                if(game.calculateRoll() == 0){
                    game.displayFarkle(uLCD);
                    break;
                }
                else{
                    game.displayScore(uLCD);
                }
            }
        }
        
        //display turn end screen
        game.displayTurnScore(uLCD);
        //wait for button to be pressed
        while(Button1){
        }
        //reset numDice
        numDice = 6;
    }
 
}