/**
Author: Kevin Lin
Title: Lab 4
Date: October 22 2021
Description: Header file of a FarkleGameObject
 
**/

#ifndef FARKLEGAME_H
#define FARKLEGAME_H
#include "die.h"
#include "Speaker.h"
#include "MMA8452.h"
#include "uLCD_4DGL.h"

class FarkleGame {
    private:
        Die diceArray[6];
        int diceValueArray[6];
        int turnScore;
        int farkleCount;
        int rollScore;
    public:
        FarkleGame();
        void rollDice(Speaker&);
        int calculateRoll();
        void changeScore();
        
        int getDiceValue(int index);
        void setDiceValue(int index, int value);
        
        void restart();
        void loadVals(int nd);
        
        void displayIntro(uLCD_4DGL&, int);
        void displayFarkle(uLCD_4DGL& screen);
        void displayScore(uLCD_4DGL& screen);
        void displayTurnScore(uLCD_4DGL&);
        void displayDice(uLCD_4DGL&, int);
        
        bool enoughGravity(MMA8452&);
        
        
};

#endif