/**
Author: Kevin Lin
Title: Lab 4
Date: October 22 2021
Description: Header file of a Farkle Game object
 
**/

#include "die.h"
#include "farklegame.h"
 
#include <string>

 
using namespace std;
 
//Constructors
FarkleGame::FarkleGame(){
    Die diceArray[6];
    int diceValueArray[6];

    int farkleCount = 0;
}
 
//Method
void FarkleGame::displayIntro(uLCD_4DGL& scr, int nd){
    scr.cls();
    scr.printf("Shake\n");
    scr.printf("Board\n");
    scr.printf("------\n");
    scr.printf("To\n");
    scr.printf("Roll\n");
    scr.printf("%d Dice", nd);
}
 
void FarkleGame::restart(){
    turnScore = 0;
    rollScore = 0;
    farkleCount = 0;
}
 
void FarkleGame::rollDice(Speaker &speaker){
    for(int i = 0; i < 6; i++){
        diceArray[i].rollDie();
        speaker.PlayNote(400.0,0.25,0.1);
    }
    
}
 
void FarkleGame::displayDice(uLCD_4DGL& scr, int nd){
    scr.cls();
    scr.display_control(PORTRAIT);
    
    for(int i = 0; i < nd; i++){
        diceArray[i].displayDie(i+1, scr);
    }
    
}
 
void FarkleGame::loadVals(int nd){
    for(int i = 0; i < 6; i++){
        diceValueArray[i] = 0;
    }
    for(int i = 0; i < nd; i++){
        if(diceArray[i].getValue() == 1){
            diceValueArray[0]++;
        }else if(diceArray[i].getValue() == 2){
            diceValueArray[1]++;
        }else if(diceArray[i].getValue() == 3){
            diceValueArray[2]++;
        }else if(diceArray[i].getValue() == 4){
            diceValueArray[3]++;
        }else if(diceArray[i].getValue() == 5){
            diceValueArray[4]++;
        }else if(diceArray[i].getValue() == 6){
            diceValueArray[5]++;
        }
    }    
}
 
int FarkleGame::calculateRoll(){
    for(int i = 0; i < 6; i++){
        if(diceValueArray[i] == 6){
            return 3000;
        }
    }
    
    int tripleCount = 0;
    for(int i = 0; i < 6; i++){
        if(diceValueArray[i] == 3) {
            tripleCount++;
        }
    }
    if(tripleCount == 2){
        return 2500;
    }
    
    //check for 5
    for(int i = 0; i < 6; i++){
        if(diceValueArray[i] == 5){
            return 2000;
        }
    }
    
    //check for 123456
    int diversityCount = 0;
    for(int i = 0; i < 6; i++){
        if(diceValueArray[i] == 1) {
        diversityCount++;
        }
    }
    if(diversityCount == 6){
        return 1500;
    }
    
    //check for 3doubs
    int doubleCount = 0;
    for(int i = 0; i < 6; i++){
        if(diceValueArray[i] == 2) {
            doubleCount++;
        }
    }
    if(doubleCount == 3){
        return 1500;
    }
 
    //check for 4
    for(int i = 0; i < 6; i++){
        if(diceValueArray[i] == 4){
            return 1000;
        }
    }
    
    //check trips
    if(tripleCount == 1){
        if(diceValueArray[0] == 3){
            return 1000;
        }else if(diceValueArray[5] == 3){
            return 600;
        }
        else if(diceValueArray[4] == 3){
            return 500;
        }else if(diceValueArray[3] == 3){
            return 400;
        }else if(diceValueArray[2] == 3){
            return 300;
        }else if(diceValueArray[1] == 3){
            return 200;
        }
    }
    
    //check 1
    if(diceValueArray[0] != 0){
        return 100;
    }
    
    //check 5
    if(diceValueArray[4] != 0){
        return 50;
    }
 
    farkleCount = farkleCount + 1;
 
    return 0;
}
 
void FarkleGame::changeScore(){
    rollScore = calculateRoll();
    turnScore += rollScore;
    if(farkleCount > 0){
        turnScore = 0;
    }
}
 
void FarkleGame::displayFarkle(uLCD_4DGL& screen){
    screen.text_width(2);
    screen.text_height(2);
    screen.locate(0,6);
    screen.printf("FARKLE!");
}
 
void FarkleGame::displayScore(uLCD_4DGL& screen){
    screen.text_width(1);
    screen.text_height(1);
    screen.locate(0,11);
    screen.printf("\nThis Turn: %d\n", turnScore);
    screen.printf("\nThis Roll: %d\n", rollScore);
}
 
void FarkleGame::displayTurnScore(uLCD_4DGL& screen){
    screen.cls();
    screen.text_width(2);
    screen.text_height(2);
    screen.locate(0,15);
    screen.printf("Turn\n");
    screen.printf("Score\n");
    screen.printf("-----\n");
    screen.printf("%d\n", turnScore);
}
 
bool FarkleGame::enoughGravity(MMA8452& acc){
    double x = 0;
    double y = 0;
    double z = 0;
    
    acc.readXYZGravity(&x,&y,&z);
    
    return (x + y > 1.1);
}
 
//S&G
void FarkleGame::setDiceValue(int pos, int v){
    diceArray[pos-1].setValue(v);
}
 
int FarkleGame::getDiceValue(int pos){
    return diceArray[pos-1].getValue();
}

   