/**
 * firmware for the mbed to brain machine project
 * see http://klautesblog.blogspot.com for further information.
 *
 * Licensed under GPLv3 - http://www.gnu.org/licenses/gpl.html
 * 
 * Written by Kai Lauterbach (klaute at gmail dot com) 04/2011
 */
 
 #include "mbed.h"

/*************************************************************************************************/
// Defining 4 of the 5 (atm) figured out brain wave frequencies as
// the period duration of the LED  PWM signals.
// The ***_HALF definitions equals to the PWM pulsewidth, which is
// the half of the brainwave frequency.

// Beta wave frequency (13-30Hz)
#define HZ_14_4      0.06940000
#define HZ_14_4_HALF 0.03470000

// Alpha wave frequency (8-13Hz)
#define HZ_11_1      0.09009009
#define HZ_11_1_HALF 0.04504504

// Theta wave frequency (4-8Hz)
#define HZ_6         0.16666666
#define HZ_6_HALF    0.08333333

// Delta waves frequency (0.5-4Hz)
#define HZ_2_2       0.45454545
#define HZ_2_2_HALF  0.22727272

// Brain frequencies with a offset of 400Hz
// for audio output.
#define HZ_414_4     0.00241312
#define HZ_411_1     0.00243249
#define HZ_406       0.00246305
#define HZ_402_2     0.00248632
// Base Frequency
#define HZ_400       0.00250000

// Brainwave types
#define ALFA  0
#define BETA  1
#define DELTA 2
#define THETA 3

#define BRAINWAVE_CTRL_DELAY 1 // in seconds

/*************************************************************************************************/

DigitalOut LEDStatus1 (LED1);
DigitalOut LEDStatus2 (LED2);

/*************************************************************************************************/

Ticker timer0;
Ticker timer1;
Ticker timer2;

/*************************************************************************************************/

PwmOut ledStatusLeft  (LED3);
PwmOut ledStatusRight (LED4);
PwmOut ledLeft  (p21);
PwmOut ledRight (p22);

/*************************************************************************************************/

DigitalOut audioRight (p23);
DigitalOut audioLeft  (p24);

/*************************************************************************************************/
typedef struct Brainwave {
    int type; // 0 = Alpha; 1 = Beta; 2 = Delta; 3 = Theta
    float duration; // in seconds
    bool  isEnd; // true = brainwave sequence end.
} Brainwave_t;

Brainwave_t brainwaves[44];

int bw_pos = 0;
int bw_duration = 0;

/*************************************************************************************************/