/**
 * firmware for the mbed to brain machine project
 * see http://klautesblog.blogspot.com for further information.
 *
 * Licensed under GPLv3 - http://www.gnu.org/licenses/gpl.html
 * 
 * Written by Kai Lauterbach (klaute at gmail dot com) 04/2011
 */

#include "main.h"

void initBrainwaves() {

    // A example brain wave sequence.
    // The sequence starts from a state of being awake.
    // Then is goes into deep meditation.
    // Hangs out there awhile, and then is will be going
    // into awake again.
    brainwaves[1-1].type = 1;
    brainwaves[1-1].duration = 60;
    brainwaves[2-1].type = 0;
    brainwaves[2-1].duration = 10;
    brainwaves[3-1].type = 1;
    brainwaves[3-1].duration = 20;
    brainwaves[4-1].type = 0;
    brainwaves[4-1].duration = 15;
    brainwaves[5-1].type = 1;
    brainwaves[5-1].duration = 15;
    brainwaves[6-1].type = 0;
    brainwaves[6-1].duration = 20;
    brainwaves[7-1].type = 1;
    brainwaves[7-1].duration = 10;
    brainwaves[8-1].type = 0;
    brainwaves[8-1].duration = 30;
    brainwaves[9-1].type = 1;
    brainwaves[9-1].duration = 5;
    brainwaves[10-1].type = 0;
    brainwaves[10-1].duration = 60;
    brainwaves[11-1].type = 3;
    brainwaves[11-1].duration = 10;
    brainwaves[12-1].type = 0;
    brainwaves[12-1].duration = 30;
    brainwaves[13-1].type = 3;
    brainwaves[13-1].duration = 20;
    brainwaves[14-1].type = 0;
    brainwaves[14-1].duration = 30;
    brainwaves[15-1].type = 3;
    brainwaves[15-1].duration = 30;
    brainwaves[16-1].type = 0;
    brainwaves[16-1].duration = 15;
    brainwaves[17-1].type = 3;
    brainwaves[17-1].duration = 60;
    brainwaves[18-1].type = 0;
    brainwaves[18-1].duration = 15;
    brainwaves[19-1].type = 1;
    brainwaves[19-1].duration = 1;
    brainwaves[20-1].type = 0;
    brainwaves[20-1].duration = 15;
    brainwaves[21-1].type = 3;
    brainwaves[21-1].duration = 60;
    brainwaves[22-1].type = 2;
    brainwaves[22-1].duration = 1;
    brainwaves[23-1].type = 3;
    brainwaves[23-1].duration = 10;
    brainwaves[24-1].type = 2;
    brainwaves[24-1].duration = 1;
    brainwaves[25-1].type = 3;
    brainwaves[25-1].duration = 10;
    brainwaves[26-1].type = 2;
    brainwaves[26-1].duration = 1;
    brainwaves[27-1].type = 3;
    brainwaves[27-1].duration = 30;
    brainwaves[28-1].type = 0;
    brainwaves[28-1].duration = 15;
    brainwaves[29-1].type = 1;
    brainwaves[29-1].duration = 1;
    brainwaves[30-1].type = 0;
    brainwaves[30-1].duration = 15;
    brainwaves[31-1].type = 3;
    brainwaves[31-1].duration = 30;
    brainwaves[32-1].type = 0;
    brainwaves[32-1].duration = 15;
    brainwaves[33-1].type = 1;
    brainwaves[33-1].duration = 1;
    brainwaves[34-1].type = 0;
    brainwaves[34-1].duration = 20;
    brainwaves[35-1].type = 1;
    brainwaves[35-1].duration = 5;
    brainwaves[36-1].type = 0;
    brainwaves[36-1].duration = 20;
    brainwaves[37-1].type = 1;
    brainwaves[37-1].duration = 15;
    brainwaves[38-1].type = 0;
    brainwaves[38-1].duration = 15;
    brainwaves[39-1].type = 1;
    brainwaves[39-1].duration = 20;
    brainwaves[40-1].type = 0;
    brainwaves[40-1].duration = 10;
    brainwaves[41-1].type = 1;
    brainwaves[41-1].duration = 25;
    brainwaves[42-1].type = 0;
    brainwaves[42-1].duration = 5;
    brainwaves[43-1].type = 1;
    brainwaves[43-1].duration = 60;
    brainwaves[44-1].isEnd = true;

}

/*************************************************************************************************/

void Audio_L_Control() {
    // Toggle left audio channel
    audioLeft = ( audioLeft == 0 ) ? 1 : 0;
}

void Audio_R_Control() {
    // toggle right audio channel
    audioRight = ( audioRight == 0 ) ? 1 : 0;
}

void Brainwave_Control() {

    // check for end of brainwave sequence
    if ( brainwaves[bw_pos].isEnd && bw_duration <= 0) {

        LEDStatus2 = ( LEDStatus2 == 0 ) ? 1 : 0;

        ledRight       = 0;
        ledLeft        = 0;
        ledStatusRight = 0;
        ledStatusLeft  = 0;

        timer0.detach();
        timer1.detach();

        return;
    }

    // check for end of duration
    if ( bw_duration > 0 ) {
        bw_duration--;
        return;
    }

    // toggle brainwave status
    LEDStatus2 = ( LEDStatus2 == 0 ) ? 1 : 0;

    bw_duration = brainwaves[bw_pos].duration;

    int   type          = brainwaves[bw_pos].type;
    float pwmPeriod     = 0.0;
    float ledPulseWidth = 0.0;
    float audioFreq     = 0.0;
    // Set the audioTimer and PWM signals to the new brain
    // wave frequency.
    switch (type) {
        case ALFA :
            audioFreq = HZ_411_1;
            pwmPeriod = HZ_11_1;
            ledPulseWidth = HZ_11_1_HALF;
            break;
        case BETA :
            audioFreq = HZ_414_4;
            pwmPeriod = HZ_14_4;
            ledPulseWidth = HZ_14_4_HALF;
            break;
        case DELTA :
            audioFreq = HZ_402_2;
            pwmPeriod = HZ_2_2;
            ledPulseWidth = HZ_2_2_HALF;
            break;
        case THETA :
            audioFreq = HZ_406;
            pwmPeriod = HZ_6;
            ledPulseWidth = HZ_6_HALF;
            break;
    }

    // reconfigure the audio timer
    timer0.attach(&Audio_L_Control, HZ_400);
    timer1.attach(&Audio_R_Control, audioFreq);

    // set the new period to all channels
    ledRight.period(pwmPeriod);

    // set the new pulse width to all pwm channels
    ledLeft.pulsewidth(ledPulseWidth);
    ledRight.pulsewidth(ledPulseWidth);
    ledStatusLeft.pulsewidth(ledPulseWidth);
    ledStatusRight.pulsewidth(ledPulseWidth);

    bw_pos++;

}

/*************************************************************************************************/

int main() {

    audioLeft  = 0;
    audioRight = 0;

    initBrainwaves();

    timer2.attach(&Brainwave_Control, BRAINWAVE_CTRL_DELAY);

    while (1) {
        LEDStatus1 = 1;
        wait(0.02);
        LEDStatus1 = 0;
        wait(0.75);
    }
}

/*************************************************************************************************/
