#include "SDC21XX_Motor.h"


namespace mbed {
    
    SDC21XX_Motor::SDC21XX_Motor(uint8_t _node_id, CAN * _can, uint8_t _channel, uint32_t _reductor): channel(_channel), reductor(_reductor), RB(_node_id, _can)
    {
        
    }
    void SDC21XX_Motor::GoAngle(int16_t _angle)
    {
        RB.SetPosition(_angle*1024/360*reductor, channel);
    }
    
    int16_t SDC21XX_Motor::GetAngle()
    {
        return RB.ReadAbsoluteEncoderCount(channel);
    }
    
    void SDC21XX_Motor::SetChannel(uint8_t _channel)
    {
        channel = _channel;
    }
    
    uint8_t SDC21XX_Motor::GetChannel(void)
    {
        return channel;
    }
    
    void SDC21XX_Motor::SetReductor(uint32_t _reductor)
    {
        reductor = _reductor;
    }
    
    uint32_t SDC21XX_Motor::GetReductor(void)
    {
        return reductor;
    }
    
    void SDC21XX_Motor::SetNodeID(uint8_t _node_id)
    {
        RB.SetNodeID(_node_id);
    }
    
    uint8_t SDC21XX_Motor::GetNodeID(void)
    {
        return RB.GetNodeID();
    }
    
    void SDC21XX_Motor::SetCan(CAN * _can)
    {
        RB.SetCan(_can);
    }
    
    CAN* SDC21XX_Motor::GetCan(void)
    {
        return RB.GetCan();
    }

    
}//end namespace