#include "Roboteq.h"


namespace mbed {
    
        Roboteq::Roboteq(uint8_t _node_id, CAN * _can) : CANopen_Node(_node_id, _can)
        {

            
        }
        
        void Roboteq::SetParameters(int16_t _velocity, long _accel, long _decel, uint8_t _channel)
        {
            SetVelocity(_velocity, _channel);
            SetAcceleration(_accel, _channel);
            SetDeceleration(_decel, _channel);
            SaveConfigToFlash();
        }
        
        void Roboteq::SetPosition(long _position, uint8_t _channel)
        {
            Send_Initiate_SDO_Download(0x2001, _channel, _position);
        }
        void Roboteq::SetVelocity(uint16_t _speed, uint8_t _channel)
        {
            Send_Initiate_SDO_Download(0x2002, _channel, _speed);
        }
        void Roboteq::SetEncoderCounter(long _counter, uint8_t _channel)
        {
            Send_Initiate_SDO_Download(0x2003, _channel, _counter);
        }
        void Roboteq::SetBrushlessCounter(long _counter, uint8_t _channel)
        {
            Send_Initiate_SDO_Download(0x2004, _channel, _counter);
        }
        void Roboteq::SetUserIntVariable(long _var, uint8_t _nb_var)
        {
            Send_Initiate_SDO_Download(0x2005, _nb_var, _var);
        }
        void Roboteq::SetAcceleration(long _accel, uint8_t _channel)
        {
            Send_Initiate_SDO_Download(0x2006, _channel, _accel);
        }
        void Roboteq::SetDeceleration(long _decel, uint8_t _channel)
        {
            Send_Initiate_SDO_Download(0x2007, _channel, _decel);
        }
        void Roboteq::SetAllDigitalOutBits(uint8_t _out_bits)
        {
            Send_Initiate_SDO_Download(0x2008, 0, _out_bits);
        }
        void Roboteq::SetIndividualDigitalOutBits(uint8_t _out_bits)
        {
            Send_Initiate_SDO_Download(0x2009, 0, _out_bits);
        }
        void Roboteq::ResetIndividualOutBits(uint8_t _out_bits)
        {
            Send_Initiate_SDO_Download(0x200a, 0, _out_bits);
        }
        void Roboteq::LoadHomeCounter(uint8_t _channel)
        {
            Send_Initiate_SDO_Download(0x200b, 0, 0);
        }
        void Roboteq::EmergencyShutdown(uint8_t _param)
        {
            Send_Initiate_SDO_Download(0x200c, 0, 0);
        }
        void Roboteq::ReleaseShutdown(uint8_t _param)
        {
            Send_Initiate_SDO_Download(0x200d, 0, 0);
        }
        void Roboteq::StopInAllModes(uint8_t _channel)
        {
            Send_Initiate_SDO_Download(0x200e, _channel, 0);
        }
        void Roboteq::SetPosRelative(long _position, uint8_t _channel)
        {
            Send_Initiate_SDO_Download(0x200f, _channel, _position);
        }
        void Roboteq::SetNextPosAbsolute(long _position, uint8_t _channel)
        {
            Send_Initiate_SDO_Download(0x2010, _channel, _position);
        }
        void Roboteq::SetNextPosRelative(long _position, uint8_t _channel)
        {
            Send_Initiate_SDO_Download(0x2011, _channel, _position);
        }
        void Roboteq::SetNextAcceleration(long _accel, uint8_t _channel)
        {
            Send_Initiate_SDO_Download(0x2012, _channel, _accel);
        }
        void Roboteq::SetNextDeceleration(long _decel, uint8_t _channel)
        {
            Send_Initiate_SDO_Download(0x2013, _channel, _decel);
        }
        void Roboteq::SetNextVelocity(uint16_t _speed, uint8_t _channel)
        {
            Send_Initiate_SDO_Download(0x2014, _channel, _speed);
        }
        void Roboteq::SetUserBoolVariable(long _var, uint8_t _nb_var)
        {
            Send_Initiate_SDO_Download(0x2015, _nb_var, _var);
        }
        void Roboteq::SaveConfigToFlash(void)
        {
            Send_Initiate_SDO_Download(0x2017, 0, 0);
        }
 
 
        int16_t Roboteq::ReadMotorAmps(uint8_t _channel)
        {
            return Send_Initiate_SDO_Upload(0x2100, _channel);
        }
        int16_t Roboteq::ReadActualMotorCommand(uint8_t _channel)
        {
            return Send_Initiate_SDO_Upload(0x2101, _channel);
        }
        int16_t Roboteq::ReadAppliedPowerLevel(uint8_t _channel)
        {
            return Send_Initiate_SDO_Upload(0x2102, _channel);
        }
        int16_t Roboteq::ReadEncoderMotorSpeed(uint8_t _channel)
        {
            return Send_Initiate_SDO_Upload(0x2103, _channel);
        }
        int16_t Roboteq::ReadAbsoluteEncoderCount(uint8_t _channel)
        {
            return Send_Initiate_SDO_Upload(0x2104, _channel);
        }
        int16_t Roboteq::ReadAbsoluteBrushlessCounter(uint8_t _channel)
        {
            return Send_Initiate_SDO_Upload(0x2105, _channel);
        }
        int16_t Roboteq::ReadUserIntegerVariable(uint8_t _nb_var)
        {
            return Send_Initiate_SDO_Upload(0x2106, _nb_var);
        }
        int16_t Roboteq::ReadEncoderMotorSpeedRelativeToMaxSpeed(uint8_t _channel)
        {
            return Send_Initiate_SDO_Upload(0x2107, _channel);
        }
        int16_t Roboteq::ReadEncoderCountRelative(uint8_t _channel)
        {
            return Send_Initiate_SDO_Upload(0x2108, _channel);
        }
        int16_t Roboteq::ReadBrushlessCountRelative(uint8_t _channel)
        {
            return Send_Initiate_SDO_Upload(0x2109, _channel);
        }
        int16_t Roboteq::ReadBrushlessMotorSpeed(uint8_t _channel)
        {
            return Send_Initiate_SDO_Upload(0x210a, _channel);
        }
        int16_t Roboteq::ReadBrushlessMotorSpeedRelativeToMaxSpeed(uint8_t _channel)
        {
            return Send_Initiate_SDO_Upload(0x210b, _channel);
        }
        int16_t Roboteq::ReadBatteryAmps(uint8_t _channel)
        {
            return Send_Initiate_SDO_Upload(0x210c, _channel);
        }
        uint16_t Roboteq::ReadInternalVoltages(uint8_t _param)
        {
            return Send_Initiate_SDO_Upload(0x210d, _param);
        }
        uint32_t Roboteq::ReadAllDigitalInputs(void)
        {
            return Send_Initiate_SDO_Upload(0x210e, 0);
        }
        int8_t Roboteq::ReadCaseAndInternalTemperatures(uint8_t _param)
        {
            return Send_Initiate_SDO_Upload(0x210f, _param);
        }
        int16_t Roboteq::ReadFeedback(uint8_t _channel)
        {
            return Send_Initiate_SDO_Upload(0x2110, _channel);
        }
        uint8_t Roboteq::ReadStatusFlags(void)
        {
            return Send_Initiate_SDO_Upload(0x2111, 0);
        }
        uint8_t Roboteq::ReadFaultFlags(void)
        {
            return Send_Initiate_SDO_Upload(0x2112, 0);
        }
        uint8_t Roboteq::ReadCurrentDigitalOutputs(void)
        {
            return Send_Initiate_SDO_Upload(0x2113, 0);

        }
        int32_t Roboteq::ReadClosedLoopError(uint8_t _channel)
        {
            return Send_Initiate_SDO_Upload(0x2114, _channel);
        }
        int32_t Roboteq::ReadUserBooleanVariable(uint8_t _nb_var)
        {
            return Send_Initiate_SDO_Upload(0x2115, _nb_var);
        }
        int32_t Roboteq::ReadInternalSerialCommand(uint8_t _channel)
        {
            return Send_Initiate_SDO_Upload(0x2116, _channel);
        }
        int32_t Roboteq::ReadInternalAnalogCommand(uint8_t _channel)
        {
            return Send_Initiate_SDO_Upload(0x2117, _channel);
        }
        int32_t Roboteq::ReadInternalPulseCommand(uint8_t _channel)
        {
            return Send_Initiate_SDO_Upload(0x2118, _channel);
        }
        uint32_t Roboteq::ReadTime(void)
        {
            return Send_Initiate_SDO_Upload(0x2119, 0);
        }
        uint16_t Roboteq::ReadSpektrumRadioCapture(uint8_t _nb_capture)
        {
            return Send_Initiate_SDO_Upload(0x211a, _nb_capture);
        }
        uint8_t Roboteq::ReadDestinationPositionReachedFlag(uint8_t _channel)
        {
            return Send_Initiate_SDO_Upload(0x211b, _channel);
        }
        int32_t Roboteq::ReadMEMSAccelerometerAxis(uint8_t _axis)
        {
            return Send_Initiate_SDO_Upload(0x211c, _axis);
        }
        uint16_t Roboteq::ReadMagsensorTrackDetect(void)
        {
            return Send_Initiate_SDO_Upload(0x211d, 0);
        }
        uint8_t Roboteq::ReadMagsensorTrackPosition(void)
        {
            return Send_Initiate_SDO_Upload(0x211e, 0);
        }
        uint8_t Roboteq::ReadMagsensorMarkers(void)
        {
            return Send_Initiate_SDO_Upload(0x211f, 0);
        }
        uint8_t Roboteq::ReadMagsensorStatus(void)
        {
            return Send_Initiate_SDO_Upload(0x2120, 0);
        }
        uint8_t Roboteq::ReadMotorStatusFlags(void)
        {
            return Send_Initiate_SDO_Upload(0x2121, 0);
        }
        int32_t Roboteq::ReadIndividualDigitalInputs(uint8_t _input)
        {
            return Send_Initiate_SDO_Upload(0x6400, _input);
        }
        int16_t Roboteq::ReadAnalogInputs(uint8_t _input)
        {
            return Send_Initiate_SDO_Upload(0x6401, _input);
        }
        int16_t Roboteq::ReadAnalogInputsConverted(uint8_t _input)
        {
            return Send_Initiate_SDO_Upload(0x6402, _input);
        }
        int16_t Roboteq::ReadPulseInputs(uint8_t _input)
        {
            return Send_Initiate_SDO_Upload(0x6403, _input);
        }
        int16_t Roboteq::ReadPulseInputsConverted(uint8_t _input)
        {
            return Send_Initiate_SDO_Upload(0x6404, _input);
        }
    
    
}