#include "mbed.h"
#include "TS_DISCO_F429ZI.h"
#include "LCD_DISCO_F429ZI.h"

extern "C" uint32_t getQuad ( uint16_t x, uint16_t y);
extern "C" uint32_t swapRedBlue ( uint32_t color);
extern "C" uint32_t toggleAlphaMSB ( uint32_t color);
extern "C" uint32_t rotateRGBBytes ( uint32_t color);
extern "C" uint32_t setRGBBits ( uint32_t color, uint8_t n);

LCD_DISCO_F429ZI lcd;
TS_DISCO_F429ZI ts;

uint32_t blue = 0xFF0000FF;
uint32_t green = 0xFF00FF00;
uint32_t red = 0xFFFF0000;
uint32_t yellow = 0xFFFFFF00;

int main()
{
    TS_StateTypeDef TS_State;
    uint16_t x, y;
    uint8_t text[30];
    uint8_t status;
  
    BSP_LCD_SetFont(&Font20);
    
    status = ts.Init(lcd.GetXSize(), lcd.GetYSize());
  
        if (status != TS_OK)
        {
            lcd.Clear(LCD_COLOR_RED);
            lcd.SetBackColor(LCD_COLOR_RED);
            lcd.SetTextColor(LCD_COLOR_WHITE);
            lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN", CENTER_MODE);
            lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"INIT FAIL", CENTER_MODE);
        }
        else
        {
          lcd.Clear(LCD_COLOR_GREEN);
          lcd.SetBackColor(LCD_COLOR_GREEN);
          lcd.SetTextColor(LCD_COLOR_WHITE);
          lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN", CENTER_MODE);
          lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"INIT OK", CENTER_MODE);
        }
    
        wait(1);
        lcd.Clear(LCD_COLOR_BLUE);
        lcd.SetBackColor(LCD_COLOR_BLUE);
        
        
    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"Project 3!!!", CENTER_MODE);
    wait(1);
    
    lcd.Clear(LCD_COLOR_WHITE);
    lcd.SetBackColor(LCD_COLOR_WHITE);
    
    wait(.5);
        
    int xSize = lcd.GetXSize()/2;
    int ySize = lcd.GetYSize()/2;
    
    int quad = 0;
    
    lcd.SetTextColor(blue); //blue
    lcd.DrawRect(0, 0, xSize, ySize);
    lcd.FillRect(0, 0, xSize, ySize);
    
    lcd.SetTextColor(green); //green
    lcd.DrawRect(0, ySize, xSize, ySize);
    lcd.FillRect(0, ySize, xSize, ySize);
    
    lcd.SetTextColor(red); //red
    lcd.DrawRect(xSize, 0, xSize, ySize);
    lcd.FillRect(xSize, 0, xSize, ySize);
    
    lcd.SetTextColor(yellow); //yellow
    lcd.DrawRect(xSize, ySize, xSize, ySize);
    lcd.FillRect(xSize, ySize, xSize, ySize);
    
    while(1)
    {
      quad = 0;
      ts.GetState(&TS_State);      
      if (TS_State.TouchDetected)
      {
        x = TS_State.X;
        y = TS_State.Y;
        sprintf((char*)text, "x=%d y=%d    ", x, y);
        lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);    
        
        quad = getQuad(x, y);
      }

        
        if(quad == 1){
            sprintf((char*)text, "QUAD:  %d", quad);
            lcd.DisplayStringAt(8, LINE(5), (uint8_t *)&text, CENTER_MODE);
            
            blue = swapRedBlue(blue);
            lcd.SetTextColor(blue);
            lcd.DrawRect(0, 0, xSize, ySize);
            lcd.FillRect(0, 0, xSize, ySize);
        }
        else if(quad == 2){
            sprintf((char*)text, "QUAD:  %d", quad);
            lcd.DisplayStringAt(8, LINE(5), (uint8_t *)&text, CENTER_MODE);
            
            red = toggleAlphaMSB(red);
            lcd.SetTextColor(red);
            lcd.DrawRect(xSize, 0, xSize, ySize);
            lcd.FillRect(xSize, 0, xSize, ySize);
        }
        else if(quad == 4){
            sprintf((char*)text, "QUAD:  %d", quad);
            lcd.DisplayStringAt(8, LINE(5), (uint8_t *)&text, CENTER_MODE);
            
            yellow = rotateRGBBytes(yellow);
            lcd.SetTextColor(yellow);
            lcd.DrawRect(xSize, ySize, xSize, ySize);
            lcd.FillRect(xSize, ySize, xSize, ySize);
        }
        else if(quad == 3){
            sprintf((char*)text, "QUAD:  %d", quad);
            lcd.DisplayStringAt(8, LINE(5), (uint8_t *)&text, CENTER_MODE);
            
            green = setRGBBits(green, 2); 
            lcd.SetTextColor(green);
            lcd.DrawRect(0, ySize, xSize, ySize);
            lcd.FillRect(0, ySize, xSize, ySize);
        }
        wait(.2);
    }
}
