#include "mbed.h"
#include "ShiftBrite.h"

//bluefruit setup
RawSerial  dev(p28,p27);
SPI spi(p11, p12, p13);

//shiftbrite setup
ShiftBrite myBrite(p15,p16,spi); //latch, enable, spi

enum color {RED, GREEN, BLUE} currColor;
char c = 'r';
int change = 0;
int musicMode = 0;

//get char from bluetooth
void dev_recv()
{
    change = 1; //new receive, change LED
    while(dev.readable()) {
        c = dev.getc();
    }
}

int main()
{
    dev.baud(9600);

    dev.attach(&dev_recv, Serial::RxIrq);
    
    //initialize shiftbrite to red
    currColor = RED;
    myBrite.Write(255, 0, 0);

    while(1) {
        //if LED has not changed, do nothing
        if (change == 0) {
            sleep();
        } else {
            if (musicMode == 0) {
                if (c == 'r') {
                    myBrite.Write(255, 0, 0);
                    currColor = RED;
                } else if (c == 'g') {
                    myBrite.Write(0, 255, 0);
                    currColor = GREEN;
                } else if (c == 'b') {
                    myBrite.Write(0 , 0, 255);
                    currColor = BLUE;
                } else if (c == 'm')
                    musicMode = 1;
            } else {
                if (c == 'm')
                    musicMode = 0;
                if (currColor == RED) {
                    if (c == '1')
                        myBrite.Write(25, 0, 0);
                    else if (c == '2')
                        myBrite.Write(50, 0, 0);
                    else if (c == '3')
                        myBrite.Write(75, 0, 0);
                    else if (c == '4')
                        myBrite.Write(100, 0, 0);
                    else if (c == '5')
                        myBrite.Write(125, 0, 0);
                    else if (c == '6')
                        myBrite.Write(150, 0, 0);
                    else if (c == '7')
                        myBrite.Write(175, 0, 0);
                    else if (c == '8')
                        myBrite.Write(200, 0, 0);
                    else if (c == '9')
                        myBrite.Write(225, 0, 0);
                } else if (currColor == GREEN) {
                    if (c == '1')
                        myBrite.Write(0, 25, 0);
                    else if (c == '2')
                        myBrite.Write(0, 50, 0);
                    else if (c == '3')
                        myBrite.Write(0, 75, 0);
                    else if (c == '4')
                        myBrite.Write(0, 100, 0);
                    else if (c == '5')
                        myBrite.Write(0, 125, 0);
                    else if (c == '6')
                        myBrite.Write(0, 150, 0);
                    else if (c == '7')
                        myBrite.Write(0, 175, 0);
                    else if (c == '8')
                        myBrite.Write(0, 200, 0);
                    else if (c == '9')
                        myBrite.Write(0, 225, 0);
                } else if (currColor == BLUE) {
                    if (c == '1')
                        myBrite.Write(0, 0, 25);
                    else if (c == '2')
                        myBrite.Write(0, 0, 50);
                    else if (c == '3')
                        myBrite.Write(0, 0, 75);
                    else if (c == '4')
                        myBrite.Write(0, 0, 100);
                    else if (c == '5')
                        myBrite.Write(0, 0, 125);
                    else if (c == '6')
                        myBrite.Write(0, 0, 150);
                    else if (c == '7')
                        myBrite.Write(0, 0, 175);
                    else if (c == '8')
                        myBrite.Write(0, 0, 200);
                    else if (c == '9')
                        myBrite.Write(0, 0, 225);
                }
            }
        change = 0;
        }
    }
}
