#include "mbed.h"
#include "arduino.h"

    AnalogIn ran(A0);
    
    DigitalIn button1(D2);
    DigitalIn button2(D3);
    DigitalIn button3(D4);
    DigitalIn button4(D5);
    
    DigitalOut led1(D7);
    DigitalOut led2(D8);
    DigitalOut led3(D9);
    DigitalOut led4(D10);
    
    DigitalOut buzzer(D12);

    const int tones[] = {1915, 1700, 1519, 1432, 2700}; // tones when you press the LED's - the last one is when you fail.

// Variables
    int buttonState[] = {0,0,0,0};         // current state of the button
    int lastButtonState[] = {0,0,0,0};     // previous state of the button
    int buttonPushCounter[] = {0,0,0,0};


void playTone(int tone, int duration) {
  for (long i = 0; i < duration * 1000L; i += tone * 2) {
    buzzer = 1;
    delayMicroseconds(tone);
    buzzer = 0;
    delayMicroseconds(tone);
  }
}

int game_on = 0;
int pause = 0;
int currentlevel = 1; // This is the level (also the number of button presses to pass to next level)
long rand_num = 0; //initialize long variable for random number from 0-100.
int rando = 0; //initialize random integer for loopgame_on. Will be from 1-4 later.
int butpause = 500; //amount of time to pause for next button input (ghetto de-bounce)
int ledtime = 500; //amount of time each LED flashes for when button is pressed
int n_levels = 10; //number of levels until the game is won
int pinandtone = 0; //This integer is used when the sequence is displayed
int right = 0; //This variable must be 1 in order to go to the next level
int speedfactor = 5; //This is the final speed of the lights and sounds for the last level. This increases as more games are won
int leddelay = 200; //Initializing time for LED. This will decrease as the level increases


int main() {
    randomSeed(ran);
    
    
    while(1) {
        int n_array[n_levels];
        int u_array[n_levels];

        int i;
            //clears arrays both "n_array" and "u_array" and starts a new game
        if (game_on == 0){
        for(i=0; i<n_levels; i=i+1){
                n_array[i]=0;
                u_array[i]=0;
                rand_num = random(1,200);
                if (rand_num <= 50){
                  rando=0;
                  }
                else if (rand_num>50 && rand_num<=100){
                    rando=1;
                  }
                else if (rand_num>100 && rand_num<=150){
                  rando=2;
                  }
                else if (rand_num<=200){
                 rando=3;
                 }
        //saves a random number in our n_array
         n_array[i]=rando;
      }
 if (i == n_levels){
   game_on = 1; 
   }

}


//shows the user the current sequence
if (pause == 0){
 delay (200);
i = 0;
for (i = 0; i < currentlevel; i= i + 1){
  leddelay = ledtime/(1+(speedfactor/n_levels)*(currentlevel - 1));
      pinandtone = n_array[i];
      if (pinandtone == 0){
        led1 = 1;
        playTone(tones[pinandtone], leddelay);
        led1 = 0;
        delay(100/speedfactor);}
      else if (pinandtone == 1){
        led2 = 1;
        playTone(tones[pinandtone], leddelay);
        led2 = 0;
        delay(100/speedfactor);}
      else if (pinandtone == 2){
        led3 = 1;
        playTone(tones[pinandtone], leddelay);
        led3 = 0;
        delay(100/speedfactor);}
      else if (pinandtone == 3){
        led4 = 1;
        playTone(tones[pinandtone], leddelay);
        led4 = 0;
        delay(100/speedfactor);}
           
    } 
    pause = 1;
}
i = 0;
int buttonchange = 0;    
int j = 0; // This is the current position in the sequence
while (j < currentlevel){    
    while (buttonchange == 0){
          for (i = 0; i < 4; i = i + 1){ 
            if (i == 0)
                buttonState[i] = button1.read();
            else if (i == 1)
                buttonState[i] = button2.read();
            else if (i == 2)
                buttonState[i] = button3.read();
            else if (i == 3)
                buttonState[i] = button4.read();
          buttonchange = buttonchange + buttonState[i];
        }
    }
    for (i = 0; i < 4; i = i + 1){
        if (buttonState[i] == 1) {
            if (i == 0){
                led1 = 1;
                playTone(tones[i], ledtime);
                led1 = 0;
            }
            else if (i == 1){
                led2 = 1;
                playTone(tones[i], ledtime);
                led2 = 0;
            }
            else if (i == 2){
                led3 = 1;
                playTone(tones[i], ledtime);
                led3 = 0;
            }
            else if (i == 3){
                led4 = 1;
                playTone(tones[i], ledtime);
                led4 = 0;
            }
                
            pause = 0;
            u_array[j]=i; 
            buttonState[i] = 0;
            buttonchange = 0;
         }
       } 
        if (u_array[j] == n_array[j]){
            j++;  
            right = 1;
            }
        else{
          
            right = 0;
            i = 4;
            j = currentlevel;
            pause = 0;
        }
}

if (right == 0){
  delay(300);
  i = 0;
  game_on = 0;
  currentlevel = 1;
  for (i = 0; i < 4; i = i + 1){
         if (i == 0)
            led1 = 1;
         else if (i == 1)
            led2 = 1;
         else if (i == 2)
            led3 = 1;
         else if (i == 3)
            led4 = 1;
         }
          playTone(tones[4], ledtime);
   for (i = 0; i < 4; i = i + 1){
         if (i == 0)
            led1 = 0;
         else if (i == 1)
            led2 = 0;
         else if (i == 2)
            led3 = 0;
         else if (i == 3)
            led4 = 0;
         }
       delay (200);
   for (i = 0; i < 4; i = i + 1){
         if (i == 0)
            led1 = 1;
         else if (i == 1)
            led2 = 1;
         else if (i== 2)
            led3 = 1;
         else if (i == 3)
            led4 = 1;
      }
        playTone(tones[4], ledtime);
   for (i = 0; i < 4; i = i + 1){
         if (i == 0)
            led1 = 0;
         else if (i == 1)
            led2 = 0;
         else if (i == 2)
            led3 = 0;
         else if (i == 3)
            led4 = 0; 
       }
       
    delay(500);
    game_on = 0;
}


//if you insert the right sequence it levels up
if (right == 1){
    currentlevel++;
    pause = 0;
    }
//if you finish the game    
if (currentlevel == n_levels){
  delay(500);
  // The following is the victory sound:
  int notes[] = {2, 2, 2, 2, 0, 1, 2, 1, 2};
  int note = 0;
  int tempo[] = {200, 200, 200, 400, 400, 400, 200, 200, 600}; 
  int breaks[] = {100, 100, 100, 200, 200, 200, 300, 100, 200}; 
  for (i = 0; i < 9; i = i + 1){
  note = notes[i];
    if (note == 0){
        led1 = 1;
        playTone(tones[note], tempo[i]);
        led1 = 0;
    }
    else if (note == 1){
        led2 = 1;
        playTone(tones[note], tempo[i]);
        led2 = 0;
    }
    else if (note == 2){
        led3 = 1;
        playTone(tones[note], tempo[i]);
        led3 = 0;
    }
    else if (note == 3){
        led4 = 1;
        playTone(tones[note], tempo[i]);
        led4 = 0;
    }
    delay(breaks[i]);
  }
//sets game_on to 0, so it restarts a new game
game_on = 0;
currentlevel = 1;
n_levels = n_levels + 2;
speedfactor = speedfactor + 1;
    }
 
}
        
    }

