#ifndef STMstation_input_h
#define STMstation_input_h

#include "mbed.h"

#define UP_PIN      PA_0
#define DOWN_PIN    PC_3
#define LEFT_PIN    PC_2
#define RIGHT_PIN   PA_1
#define A_PIN       PB_10
#define B_PIN       PB_12
#define X_PIN       PB_1
#define Y_PIN       PB_2
#define START_PIN   PB_4
#define SELECT_PIN  PB_5

#define BAT_PIN     PC_0

/** Input library for the STMstation P.1
 *  Provides information on button states (keydown, keyup, keypress) for each of the
 *  10 user buttons (up, down, left, right, a, b, x, y, start, select).
 */
class STMstation_input{
    public:
        ///Create an instance of STMstation_input
        STMstation_input();
        enum Button {UP, DOWN, LEFT, RIGHT, A, B, X, Y, START, SELECT};
        ///Update the state of all buttons
        void updateButtons();
        ///Check if a keydown event has occurred
        bool keyDown(Button b);
        ///Check if a keyup event has occurred
        bool keyUp(Button b);
        ///Check if a button is pressed
        bool keyPress(Button b);
        ///Check battery voltage
        float batCheck();
    private:
        bool buttonPress[10];
        bool buttonDown[10];
        bool buttonUp[10];
        DigitalIn D_UP, D_DOWN, D_LEFT, D_RIGHT, D_A, D_B, D_X, D_Y, D_START, D_SELECT;
        AnalogIn bat;
};

#endif