#include "STMstation_input.h"
#include "mbed.h"

STMstation_input::STMstation_input():   D_UP(UP_PIN), D_DOWN(DOWN_PIN), D_LEFT(LEFT_PIN), D_RIGHT(RIGHT_PIN),
                                        D_A(A_PIN), D_B(B_PIN), D_X(X_PIN), D_Y(Y_PIN),
                                        D_START(START_PIN), D_SELECT(SELECT_PIN), bat(BAT_PIN)
{
}

void STMstation_input::updateButtons(){
    bool oldState[10];
    
    for(int i=0; i<10; i++){
        oldState[i] = buttonPress[i];
    }
    buttonPress[0] = D_UP;
    buttonPress[1] = D_DOWN;
    buttonPress[2] = D_LEFT;
    buttonPress[3] = D_RIGHT;
    buttonPress[4] = D_A;
    buttonPress[5] = D_B;
    buttonPress[6] = D_X;
    buttonPress[7] = D_Y;
    buttonPress[8] = D_START;
    buttonPress[9] = D_SELECT;
    for(int i=0; i<10; i++){
        if(oldState[i] == 0 & buttonPress[i] == 1){
            buttonDown[i] = 1;
            buttonUp[i] = 0;
        }
        else if(oldState[i] == 1 & buttonPress[i] == 0){
            buttonDown[i] = 0;
            buttonUp[i] = 1;
        }
        else{
            buttonDown[i] = 0;
            buttonUp[i] = 0;
        }
    }
}

bool STMstation_input::keyDown(Button b){
    if(buttonDown[b] == 0){
        return 0;
    }
    else{
        return 1;
    }
}

bool STMstation_input::keyUp(Button b){
    if(buttonUp[b] == 0){
        return 0;
    }
    else{
        return 1;
    }
}

bool STMstation_input::keyPress(Button b){
    if(buttonPress[b] == 0){
        return 0;
    }
    else{
        return 1;
    }
}

float STMstation_input::batCheck(){
    float voltage = bat.read()*3.3f*159.0f/120;
    return voltage;
}