#ifndef __RECT_H_
#define __RECT_H_

#include "Point.h"

template <class T>
class Rect {
    
public:
    Rect():
    _x(0),
    _y(0),
    _width(0),
    _height(0)
    {}
    
    Rect(T x, T y, T width, T height):
    _x(x),
    _y(y),
    _width(width),
    _height(height)
    {}
    
    T x() const {return _x;}
    T y() const {return _y;}
    void setX(T x){_x = x;}
    void setY(T y){_y = y;}
    
    T width()  const {return _width;}
    T height() const {return _height;}
    void setWidth(T  w) {_width  = w;}
    void setHeight(T h) {_height = h;}
    
    Point<T> topLeft()     const { return Point<T>(_x, _y);                }
    Point<T> topRight()    const { return Point<T>(_x+_width, _y);         }
    Point<T> bottomLeft()  const { return Point<T>(_x, _y+_height);        }
    Point<T> bottomRight() const { return Point<T>(_x+_width, _y+_height); }
    
    void moveTo(T x, T y)
    {
        _x = x;
        _y = y;
    }
    
    void moveTo( const Point<T> &p)
    {
        _x = p.x();
        _y = p.y();
    }
    
    bool isNull() const {return (_x == 0 && _y == 0 && _width == 0 && _height == 0);}
    
    friend inline bool operator==(const Rect &r1, const Rect &r2){return (r1._x==r2._x && r1._width==r2._width && r1._y==r2._y && r1._height==r2._height);}
    friend inline bool operator!=(const Rect &r1, const Rect &r2){return (r1._x!=r2._x || r1._width!=r2._width || r1._y!=r2._y || r1._height!=r2._height);}
    
    bool contains(const Point<T> &p) const
    {
        T l = xp;
        T r = xp;
        if (w < 0)
            l += w;
        else
            r += w;
        if (l == r) // null rect
            return false;
    
        if (p.x() < l || p.x() > r)
            return false;
    
        T t = yp;
        T b = yp;
        if (h < 0)
            t += h;
        else
            b += h;
        if (t == b) // null rect
            return false;
    
        if (p.y() < t || p.y() > b)
            return false;
    
        return true;
    }
    
private:
    T _x; // Left xpos
    T _y; // Top ypos
    T _width;
    T _height;
};


#endif // __RECT_H_