#ifndef __POINT_H_
#define __POINT_H_

template <class T>
class Point
{
    public:
    Point():
    _x(0),
    _y(0)
    {}
    
    Point(T x, T y):
    _x(x),
    _y(y)
    {}
    
    T x(){return _x;}
    T y(){return _y;}
    T& rx(){return _x;}
    T& ry(){return _y;}
    void setX(T x){_x = x;}
    void setY(T y){_y = y;}
    bool isNull()const{return (_x==0 && _y==0);}

    Point& operator*=(T factor){_x*=factor; _y*=factor; return *this;}
    Point& operator+=(const Point& point){_x+=p._x; _y+=p._y; return *this;}
    Point& operator-=(const Point& point){_x-=p._x; _y-=p._y; return *this;}

    friend inline bool   operator==( const Point &p1, const Point &p2 ){ return p1._x == p2._x && p1._y == p2._y; }
    friend inline bool   operator!=( const Point &p1, const Point &p2 ){ return p1._x != p2._x || p1._y != p2._y; }
    friend inline const Point operator+( const Point &p1, const Point &p2 ){ return Point(p1._x+p2._x, p1._y+p2._y); }
    friend inline const Point operator-( const Point &p1, const Point &p2 ){ return Point(p1._x-p2._x, p1._y-p2._y); }
    friend inline const Point operator*( const Point &p, int factor){ return Point(p._x*factor, p._y*factor);}
    
    private:
    T _x;
    T _y;    
};

#endif // __POINT_H_