//OLED_RST  PA_12
//DC        PA_11
//SCK       PA_5
//MOSI      PA_7
//OLED_CS   PC_9

/*
#include "mbed.h"
#include "SSD1331.h"

int main(){
    //Init the screen (CS, RST, DC, MOSI, MISO, SCLK)
    SSD1331 oled(PC_9, PA_12, PA_11, PA_7, NC, PA_5);
    oled.drawLine(0, 0, 95, 0, Yellow);
}
*/

#include "mbed.h"
#include "ssd1331.h"
 
ssd1331 oled(PC_9, PA_12, PA_11, PA_7, NC, PA_5); // cs, res, dc, miso(nc), sck (KL25z)
 
//char Time[50],Date[50];
//void gettime();
 
uint8_t main() { 
 
    while(1){
        
        oled.Fill_Screen(oled.toRGB(255,0,0)); //red
        wait_ms(500);
        oled.Fill_Screen(oled.toRGB(0,255,0)); //green
        wait_ms(500);
        oled.Fill_Screen(oled.toRGB(0,0,255)); //blue
        wait_ms(500);
        oled.Fill_Screen(oled.toRGB(255,255,255)); //white
        wait_ms(500);
        
        oled.cls(); // clear screen to black
 
        oled.circle (20, 40, 30 ,oled.toRGB(0,0,255) , 1);      //fill circle
        oled.circle (20, 40, 30 ,oled.toRGB(255,255,255) , 0);  //circle 
        oled.circle (20, 60, 40 ,oled.toRGB(255,0,0) , 0);      //circle
        oled.line( 0, 0, width, height, oled.toRGB(0,255,255)); //line
        oled.line( width, 0, 0, height, oled.toRGB(255,0,255)); //line
        //oled.rectangle(10,10,90,60,oled.toRGB(255,255,0));      //rectangle
        //oled.fillrectangle(20,20,40,40,oled.toRGB(255,255,255),oled.toRGB(0,255,0)); //fillrectangle
        
        for(uint8_t y = 9; y >= 0; y--) {
             oled.contrast(y);  // set contrast level
             oled.foreground(oled.toRGB(255,255,255)); // set text colour
             oled.locate(1, 10); // set text start location
             oled.printf("%d",y); // std printf
             wait_ms(300);
        }  
        
        wait_ms(1000);
        oled.contrast(9); // set contrast to maximum
        wait_ms(2000);
        oled.cls();
 
        oled.SetFontSize(HIGH); // set tall font
        oled.foreground(oled.toRGB(0,255,0)); // set text colour
        oled.locate(0, 10);
        oled.printf( "HIGH 12345");  
        
        oled.SetFontSize(WIDE); // set text to wide
        oled.foreground(oled.toRGB(0,0,255));
        oled.locate(0, 28);
        oled.printf( "WIDE 123");  
        
        oled.SetFontSize(WH); // set text to wide and tall
        oled.foreground(oled.toRGB(255,0,0));
        oled.locate(0, 40);
        oled.printf( "WH 123");
        
        oled.SetFontSize(NORMAL); // set text to normal
        oled.foreground(oled.toRGB(255,255,255));      
                
        oled.ScrollSet(0,8,18,1,0); // set scroll function
        oled.Scrollstart(); // start scroll
       
        //gettime();wait(1);gettime();wait(1);gettime();wait(1);      
        oled.ScrollSet(0,8,18,-2,0);
        oled.Scrollstart();       
        //gettime();wait(1);gettime();wait(1);gettime();wait(1);
        
        oled.ScrollSet(0,8,18,3,0);
        oled.Scrollstart();
        
        //gettime();wait(1);gettime();wait(1);gettime();wait(1);
        
        oled.ScrollSet(0,8,18,-4,0);
        oled.Scrollstart();
       
        //gettime();wait(1);gettime();wait(1);gettime();wait(1);
        
        oled.Scrollstop(); // stop scroll
        wait(1);
     }               
}

/*
void gettime()
{    
    time_t seconds = time(NULL);
    strftime(Time,40,"%H:%M:%S %a", localtime(&seconds));
    strftime(Date,40,"%d-%b-%Y", localtime(&seconds));
    oled.locate(0, 0);
    oled.printf(Time); 
}
*/