#include "mbed.h"
#include "USBHostMIDI.h"
#include "MIDISpeaker.h"
#include "Watchdog.h"

//#include "uLCD_4DGL.h"

DigitalOut myled (LED1);
MIDISpeaker myspeaker(p21); //ini
Watchdog wdt; //create Watchdog Timer object



void noteOn(unsigned char channel, unsigned char note, unsigned char velocity) {
    wdt.kick(3.0); //start watchdog timer
    myled = 1.0; //turn on LED1 on note press
    myspeaker.PlayNote(note, velocity);
    //uLCD.printf("\nkey: %d, velocity: %d\r\n", note, velocity);
  
}


void noteOff(unsigned char channel, unsigned char note, unsigned char velocity) {
    wdt.kick(); //reset watchdog timer when noteoff is called
    myled = 0.0; //turn off LED1 on note release
    myspeaker.StopNote();

}


void midi_task(void const*) {
    // create usbhost midi object
    USBHostMIDI midi;
    
    // attach midi event callbacks
    midi.attachNoteOn(noteOn);
    midi.attachNoteOff(noteOff);
 

    while(1) {
        // try to connect a midi device
        while(!midi.connect())
            Thread::wait(500);
        
        // if the device is disconnected, we try to connect it again
        while (1) {
            // if device disconnected, try to connect it again
            if (!midi.connected())
                break;
            
            Thread::wait(1);
        }
    }
}

int main() {
    if ((LPC_WDT->WDMOD >> 2) & 1) //indicate if watchdog timer has not been kicked, and resets mbed
        myled4 = 1; else myled3 = 1;
    
    uLCD.background_color(BLUE); //set background for spectrum analyzer
    uLCD.cls();
    uLCD.line(5,110,120,110,WHITE); // x-axis
    uLCD.line(5,5,5,110, WHITE); //y-axis
  
    Thread midiTask(midi_task, NULL, osPriorityNormal, 256 * 4);
    while(1) {
        Thread::wait(50);
        //wdt.kick();
        myled4=!myled4; //blink LED4 to indicate that mbed is ready to receive input from keyboard      
    }
}