#include "mbed.h"
#include <math.h>
AnalogIn thermistor(P0_3);

int beta = 3975;
float temperature, resistance;

float getTemp() {
    unsigned int a = thermistor.read_u16(); /* Read analog value 16 bit 65536*/
    
    /* Calculate the resistance of the thermistor from analog votage read. positive feedback 100k to ground 10 bit ADC*/
    resistance= (float) 100000.0 * ((1023.0 / a) - 1.0);

    /* Convert the resistance to temperature using Steinhart's Hart equation */
    temperature=(1/((log(resistance/100000.0)/beta) + (1.0/298.15)))-273.15; 
    return temperature;
}