/* NetworkSocketAPI Example Program
 * Copyright (c) 2015 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "ESP8266Interface.h"

DigitalOut myled(LED1);
DigitalOut status(LED2);
void flash(){ myled = !myled; }

void setStatus(int num){
    for(int i = 0; i < num * 2; ++i){
        status = !status;
        wait(0.2f);
    }
}

ESP8266Interface wifi(P0_23, P0_21);

static SocketInterface* mySocket;
void wifiInit() {
    wifi.init();
    int cs = wifi.connect("DemoRoom", "");
    setStatus(cs == 0 ? 1 : 3);

    mySocket = wifi.allocateSocket(SOCK_TCP);

    mySocket->setAddressPort("192.168.2.235", 1234);
    mySocket->open();
    
    //TODO
    //mySocket->close();
    //wifi.disconnect();
}

void wifiSend(float temp) {
    setStatus(1);
    mySocket->send(&temp, sizeof(temp), 100);
}