/* Digital Lock System
Components Used:
NGX Baseboord
MPR121 Capacitive touch panel as keypad( p26, p9, p10)// IRQ, SDA, SCL
LCD for display(p24, p25, p27, p28, p29, p30) // rs, e, d4-d7
Motor for opening/closing the lock(p11, p12) // for input in H Bridge 
Baseboard SD Card for storing Forest.wav
Baseboard audio jack 3.5 mm 

By using touch panel as input we enter the desired password to open the lock. 
Initially we store a password in array ORG[] which can be compared with the password(length= 7)entered by the user.

If the entered password is correct then motor opens the door. 
In case of wrong password the user is asked to re-enter the password. 3 trials are given after which door is permanently
 locked.
Option to change the password is also provided.
The process is guided by display of instruction on the LCD. 


Under Progress:
An attempt is being made to guide the user by playing relavent audio files along with the instructions on LCD. 
The "forest.wav" file is the one that we are attempting to play along with LCD instructions.
the bit rate of the wave file is 176kbps.  
*/



#include "mbed.h"
#include "SDFileSystem.h"
#include <string>
#include <list>
#include <mpr121.h>
#include "TextLCD.h"
#include <stdio.h>
#include <stdlib.h>
#include <sstream>
#include <iostream>                                                             


//------------------------------------------------------------------initialize lcd

TextLCD lcd(p24, p25, p27, p28, p29, p30); // rs, e, d4-d7
//--------------------------------------------------------------------

//------------------------------------------------------------------initial touch pannel
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
DigitalOut servo(p12);
int org[7] = {0,0,0,0,0,0,0};
int Nums[7] = {0,0,0,0,0,0,0};
int counter = 0;
int count2 = 0;
int k=0;
DigitalOut servo1(p11);
DigitalOut servo2(p12);
//------------------------------------------- Create the interrupt receiver object on pin 26
InterruptIn interrupt(p26);
 

//-------------------------------------------------------- Setup the i2c bus on pins 28 and 27
I2C i2c(p9, p10);
 

//------------------------------------------ constructor(i2c object, i2c address of the mpr121)
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);

//-------------------------------------------------------------------touch panel initialised



//---------------------------------------------------------------------------------------------playing audio
AnalogOut DACout(p18);
//DigitalOut digout(LED4);
Ticker tick;
SDFileSystem sd(p5, p6, p7, p8, "sd"); // NGX mbed base board

#define SAMPLE_FREQ 40000
#define BUF_SIZE (SAMPLE_FREQ/10)
#define SLICE_BUF_SIZE 1

void dac_out(void);
void play_wave(char *);
void cleanup(char *);
void fill_adc_buf(short *, unsigned);
void swapword(unsigned *);

// a FIFO for the DAC
short DAC_fifo[256];
short DAC_wptr;
short DAC_rptr;
short DAC_on;

typedef struct uFMT_STRUCT {
short comp_code;
short num_channels;
unsigned sample_rate;
unsigned avg_Bps;
short block_align;
short sig_bps;
} FMT_STRUCT;



void play_wave(char *wavname)
{
unsigned chunk_id,chunk_size,channel;
//        unsigned *data_wptr,data,samp_int,i;
unsigned data,samp_int,i;
short dac_data;
char *slice_buf;
short *data_sptr;
//        char *data_bptr;
FMT_STRUCT wav_format;
FILE *wavfile;
long slice,num_slices;
DAC_wptr=0;
DAC_rptr=0;
for (i=0;i<256;i+=2) 
    {
    DAC_fifo[i]=0;
    DAC_fifo[i+1]=3000;
    }
DAC_wptr=4;
DAC_on=0;

led1=led2=led3=led4=0;
lcd.cls();
lcd.printf("Playing wave file '%s'\n",wavname);

wavfile=fopen(wavname,"rb");
if (!wavfile) {
    lcd.cls();
    printf("Unable to open wav file '%s'\n",wavname);
    exit(1);
    }

fread(&chunk_id,4,1,wavfile);
fread(&chunk_size,4,1,wavfile);
while (!feof(wavfile)) {


    lcd.cls();
    lcd.printf("Read chunk ID 0x%x, size 0x%x\n",chunk_id,chunk_size);
    switch (chunk_id) {
      case 0x46464952:
        fread(&data,4,1,wavfile);
        lcd.cls();
        lcd.printf("RIFF chunk\n");
        wait(1);
        lcd.cls();
        lcd.printf("  chunk size %d (0x%x)\n",chunk_size,chunk_size);
        lcd.cls();
        lcd.printf("  RIFF type 0x%x\n",data);
        break;
      case 0x20746d66:
        fread(&wav_format,sizeof(wav_format),1,wavfile);
        lcd.cls();
        lcd.printf("FORMAT chunk\n");
        wait(1);
        lcd.cls();
        lcd.printf("  chunk size %d (0x%x)\n",chunk_size,chunk_size);
        wait(1);
        lcd.cls();
        lcd.printf("  compression code %d\n",wav_format.comp_code);
        wait(1);
        lcd.cls();
        lcd.printf("  %d channels\n",wav_format.num_channels);
        wait(1);
        lcd.cls();
        lcd.printf("  %d samples/sec\n",wav_format.sample_rate);
        wait(1);
        lcd.cls();
        lcd.printf("  %d bytes/sec\n",wav_format.avg_Bps);
        wait(1);
        lcd.cls();
        lcd.printf("  block align %d\n",wav_format.block_align);
        wait(1);
        lcd.cls();
        lcd.printf("  %d bits per sample\n",wav_format.sig_bps);
        if (chunk_size > sizeof(wav_format))
        fseek(wavfile,chunk_size-sizeof(wav_format),SEEK_CUR);
// create a slice buffer large enough to hold multiple slices
        slice_buf=(char *)malloc(wav_format.block_align*SLICE_BUF_SIZE);
        if (!slice_buf) {
        lcd.cls();
        lcd.printf("Unable to malloc slice buffer");
        exit(1);
        }
        break;
      case 0x61746164:
        slice_buf=(char *)malloc(wav_format.block_align*SLICE_BUF_SIZE);
        if (!slice_buf) {
        lcd.cls();
        lcd.printf("Unable to malloc slice buffer");
        exit(1);
        }        num_slices=chunk_size/wav_format.block_align;
        lcd.cls();
        lcd.printf("DATA chunk\n");
        lcd.cls();
        lcd.printf("  chunk size %d (0x%x)\n",chunk_size,chunk_size);
        lcd.cls();
        lcd.printf("  %d slices\n",num_slices);
        lcd.cls();
        lcd.printf("  Ideal sample interval=%d\n",(unsigned)(1000000.0/wav_format.sample_rate));
        samp_int=1000000/(wav_format.sample_rate);
        lcd.cls();
        lcd.printf("  programmed interrupt tick interval=%d\n",samp_int);
// starting up ticker to write samples out -- no printfs until tick.detach is called
        tick.attach_us(&dac_out, samp_int); 
        DAC_on=1; 
        led2=1;
        for (slice=0;slice<num_slices;slice+=SLICE_BUF_SIZE) {
        fread(slice_buf,wav_format.block_align*SLICE_BUF_SIZE,1,wavfile);
        if (feof(wavfile)) {
        lcd.cls();
         lcd.printf("Oops -- not enough slices in the wave file\n");
        exit(1);
          }
          data_sptr=(short *)slice_buf;
          for (i=0;i<SLICE_BUF_SIZE;i++) {
          dac_data=0;

// for a stereo wave file average the two channels.
            for (channel=0;channel<wav_format.num_channels;channel++) {
              switch (wav_format.sig_bps) {
                case 16:
                  dac_data+=(  ((int)(*data_sptr++)) +32768)>>5;
                  break;
              }
            }
            dac_data>>=1;
            DAC_fifo[DAC_wptr]=dac_data;
            DAC_wptr=(DAC_wptr+1) & 0xff;
            while (DAC_wptr==DAC_rptr) {
            led1=1;
            }
            led1=0;
          }
        }
        DAC_on=0;
        led2=0;
        tick.detach();
        lcd.cls();
        lcd.printf("Ticker detached\n");
        led3=1;
        free(slice_buf);
        break;
      case 0x5453494c:
      lcd.cls();
      lcd.printf("INFO chunk, size %d\n",chunk_size);
        fseek(wavfile,chunk_size,SEEK_CUR);
        break;
      default:
      lcd.cls();
      lcd.printf("unknown chunk type 0x%x, size %d\n",chunk_id,chunk_size);
        data=fseek(wavfile,chunk_size,SEEK_CUR);
        break;
    }
    fread(&chunk_id,4,1,wavfile);
    fread(&chunk_size,4,1,wavfile);
  }
  lcd.cls();
  lcd.printf("Done with wave file\n");
  fclose(wavfile);
  led1=0;
}


void dac_out()
{
  if (DAC_on) {
    led4=1;
    DACout.write_u16(DAC_fifo[DAC_rptr]);
    DAC_rptr=(DAC_rptr+1) & 0xff;
    led4=0;
  }
}

    


//---------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------obtaining input


void fallInterrupt() {
int key_code=0;
    int i=0;
    int value=mpr121.read(0x00);
    value +=mpr121.read(0x01)<<8;
    
    i=0;
    // puts key number out to LEDs for demo
    for (i=0; i<12; i++) 
    {
        if (((value>>i)&0x01)==1) 
        {  
           if(counter==0)
             {
              lcd.cls();
              lcd.printf("");
             }
            key_code=i;
            lcd.printf("%d", i);
            if(counter < 7)
            {
               
                Nums[counter] = i;
                counter++;
            }
        }
    }
    led4=key_code & 0x01;
    led3=(key_code>>1) & 0x01;
    led2=(key_code>>2) & 0x01;
    led1=(key_code>>3) & 0x01;
}
 

//------------------------------------------------------------------------------MAIN


int main()
{

//------------------------------------------------to start enter new password which user wants to set
lcd.cls();
lcd.printf("enter your new password\n");

//play_wave("/sd/forest.wav");
wait(0.5);

  int k;
  //----------------------------------------------enter password
  while(1)
    { 
    interrupt.fall(&fallInterrupt);
    interrupt.mode(PullUp);
    if(counter==7){
    break;}
    }
    
   
  for (k=0; k<7; k++)
  {
    org[k]=Nums[k];
  }
    
  wait(1);
     
AGAIN:    
    lcd.cls();
    lcd.printf("1-open door\n2-reset password");
    play_wave("/sd/forest.wav");
    interrupt.fall(&fallInterrupt);
    interrupt.mode(PullUp);
  
  while (1) 
  {
  counter=0;
  if(Nums[0]==1)
    { 
    lcd.cls();    
    //---------------------------------------------------enter the password
    lcd.printf("enter your password\n");
    play_wave("/sd/forest.wav");
    wait(1);
    
    while(1)
        {
        interrupt.fall(&fallInterrupt);
        interrupt.mode(PullUp);
        if(counter==7){break;}
        }
             if(counter == 7)
                   {
                       wait(1);    
                       //lcd.printf("%d",Nums[4]);
                           for(k=0;k<7;k++)
                           {
                           lcd.printf("%d",Nums[k]); 
                           wait(1);
                           }
                           if((Nums[0] == org[0]) && (Nums[1] == org[1]) && (Nums[2] == org[2])&&(Nums[3] == org[3]) && (Nums[4] == org[4]) &&(Nums[5] == org[5])&& (Nums[6] == org[6]))
                           {
                              lcd.cls();
                              lcd.printf("password is correct, door open\n"); 
                              servo=1;
                              wait(1);
                              lcd.cls();
                              lcd.printf("opening door...\n"); 
                               play_wave("/sd/forest.wav");
                              servo1 = 1;
        servo2 = 0;
        wait(5);
        servo1 = 0;
        servo2 = 1;
        wait(5);
                              goto AGAIN;
                           }
       else
       {
       
       lcd.cls();
       lcd.printf("password incorrect.retry\n"); 
       play_wave("/sd/forest.wav");
       wait(10);
       goto AGAIN;
       }
       }
       }
       
       
       wait(1); 
       if(Nums[0]==2)
       {   
         wait(1);
         counter=0;
         lcd.cls();
         lcd.printf("enter your old password\n");
         play_wave("/sd/forest.wav");
         while(1)
         {
         interrupt.fall(&fallInterrupt);
         interrupt.mode(PullUp);
         if(counter==7){break;}
         }
  
    if(counter == 7)
    {
   
       if((Nums[0] == org[0]) && (Nums[1] == org[1]) && (Nums[2] == org[2])&&(Nums[3] == org[3]) && (Nums[4] == org[4]) &&(Nums[5] == org[5])&& (Nums[6] == org[6]))
       {
       counter=0;
       lcd.cls();
       lcd.printf("enter your new password"); 
       play_wave("/sd/forest.wav");
       while(1)
        {
        interrupt.fall(&fallInterrupt);
        interrupt.mode(PullUp);
        if(counter==7){break;}
        }
  
         for (k=0; k<7; k++)
         {
          org[k]=Nums[k];
         }
  
       lcd.cls();
       lcd.printf("password changed");
       play_wave("/sd/forest.wav");
       goto AGAIN;
       }
       else
       {
        lcd.cls();
        lcd.printf("password incorrect.retry\n");
       k++;
       if(k==3)
       {
       lcd.cls();
        lcd.printf("Locked");
        wait(30);
       }
       play_wave("/sd/forest.wav");
        goto AGAIN;
        }
        }
}
else
{
goto AGAIN;
}
}
}
