#include "RS485.h"
#include "mbed.h"
#include "ActuatorHub/ActuatorHub.h"
#include "../../LED/LED.h"
#include "../../System/Using.h"

namespace RS485 {
    DigitalOut selectBit(SELECTBIT_PIN);
    Serial RS485Uart(RS485UART_TX, RS485UART_RX);

    void Transmit();

    void RS485::Initialize() {
        selectBit = 1;  //送信固定
        RS485Uart.baud(38400);
        RS485Uart.attach(Transmit, Serial::TxIrq);
    }

    void Transmit() {
        static uint8_t count = 0;
        __disable_irq();
        RS485Uart.putc(RS485SendBuffer.GetData());
        if(count >= 200) {
            #ifdef USE_MOTOR
            LED_DEBUG2 = !LED_DEBUG2;
            #endif

            count = 0;
        } else count++;
        __enable_irq();
    }
}
