#ifndef PROCESS_H_
#define PROCESS_H_

#include "mbed.h"

void SystemProcess();

#define ROLLER_LF motor[ROLLER_LF_NUM]
#define ROLLER_LL motor[ROLLER_LL_NUM]
#define ROLLER_LB motor[ROLLER_LB_NUM]
#define ROLLER_LR motor[ROLLER_LR_NUM]
#define ROLLER_CF motor[ROLLER_CF_NUM]
#define ROLLER_CL motor[ROLLER_CL_NUM]
#define ROLLER_CB motor[ROLLER_CB_NUM]
#define ROLLER_CR motor[ROLLER_CR_NUM]
#define ROLLER_RF motor[ROLLER_RF_NUM]
#define ROLLER_RL motor[ROLLER_RL_NUM]
#define ROLLER_RB motor[ROLLER_RB_NUM]
#define ROLLER_RR motor[ROLLER_RR_NUM]

#define ROLLER_LF_NUM 8
#define ROLLER_LL_NUM 9
#define ROLLER_LB_NUM 13
#define ROLLER_LR_NUM 14
#define ROLLER_CF_NUM 15
#define ROLLER_CL_NUM 16
#define ROLLER_CB_NUM 17
#define ROLLER_CR_NUM 18
#define ROLLER_RF_NUM 19
#define ROLLER_RL_NUM 20
#define ROLLER_RB_NUM 21
#define ROLLER_RR_NUM 22

#define FRONT_R tire[0]
#define FRONT_L tire[1]
#define REAR_L tire[2]
#define REAR_R tire[3]

#define TIRE_FR motor[0]
#define TIRE_FL motor[1]
#define TIRE_RL motor[2]
#define TIRE_RR motor[3]
#define STR_FR motor[4]
#define STR_FL motor[5]
#define STR_RL motor[6]
#define STR_RR motor[7]

#define SENSOR_FR POTENTIOMETER::adc[1].read_u16()
#define SENSOR_FL (POTENTIOMETER::adc[2].read_u16() / 65535.0 * 1024.0)
#define SENSOR_RL POTENTIOMETER::adc[3]
#define SENSOR_RR POTENTIOMETER::adc[4]

#define PLUS90_FR 605
// #define PLUS90_FL 31100
#define PLUS90_FL 480
#define PLUS90_RL 505
#define PLUS90_RR 550

#define ZERO_FR 880
// #define ZERO_FL 48800
#define ZERO_FL 760
#define ZERO_RL 775
#define ZERO_RR 800




#endif
