#include "mbed.h"
#include "VL53L0X.h"
#include "TCS3200.h"

////////////////////// Переменные для драйверов моторов.
DigitalOut M1inA(PC_7);
DigitalOut M1inB(PA_6);
DigitalOut M1pwm(PB_6);
DigitalOut M2inA(PA_12);
DigitalOut M2inB(PA_11);
DigitalOut M2pwm(PB_12);
DigitalOut M12inA(PC_9);
DigitalOut M12inB(PC_8);
DigitalOut M12pwm(PA_7);

int a = 1;


#define ON 1;
#define OFF 0;
#define mPWM a;
///////////////////////Переменные для дальномеров.

 I2C         i2c(D14, D15);    
 VL53L0X     vl_sensor(&i2c);
 DigitalOut  vl_shutdown(PA_10);
 
 
 
#define SDA_pin D14
#define SCL_pin D15


/////////////////////////////////////////////////////////

Serial pc(SERIAL_TX, SERIAL_RX);

//////////////////////////  Для дальномеров.

 void VL53L0X()
 {
   pc.printf("Single VL53L0X\n\n\r");
  
   vl_shutdown = 1;  //turn VL53L0X on
   vl_sensor.init();
   vl_sensor.setModeContinuous();
   vl_sensor.startContinuous();
   
   for(int VL = 0; VL <= 5; VL++)
   {
     pc.printf("%4imm\n\r", vl_sensor.getRangeMillimeters());
   }
 }
////////////////////////////////////Для датчиков цвета.

 TCS3200 color(PH_0, PH_1, PC_2, PC_3, PA_15); 
 //            S0    S1    S2     S3     OUT
 
  void colors() {
     long red, green, blue, clear;
    
     //Set the scaling factor to 100%
     color.SetMode(TCS3200::SCALE_100);        
 
     for(int TC = 0; TC <= 1; TC++) 
     {
         //Read the HIGH pulse width in nS for each color.
         //The lower the value, the more of that color is detected 
         red = color.ReadRed();
         green = color.ReadGreen();
         blue = color.ReadBlue();
         clear = color.ReadClear();
 
         printf("RED: %10d \n GREEN: %10d \n BLUE: %10d \n CLEAR: %10d \n_____________\n  ", red, green, blue, clear);
            
         wait(0.1);
     }
 }


////////////////////////////////////Для драйверов моторов.
    void rotate_right()
        {
            M1inA = ON;
            M1inB = OFF;
            M1pwm = mPWM;
            //motor 1
            M2inA = ON;
            M2inB = OFF;
            M2pwm = mPWM;
            //motor 2
            M12inA = ON;
            M12inB = OFF;
            M12pwm = mPWM;
            //motor 3
            pc.printf("\n rotate right \n");
        }
        
    void rotate_left()
        {
            M1inA = OFF;
            M1inB = ON;
            M1pwm = mPWM;
            //motor 1
            M2inA = OFF;
            M2inB = ON;
            M2pwm = mPWM;
            //motor 2
            M12inA = OFF;
            M12inB = ON;
            M12pwm = mPWM;
            //motor 3
            pc.printf("\n rotate left \n");
        }

    void up()
        {
            M1inA = OFF;
            M1inB = ON;
            M1pwm = mPWM;
            //motor 1
            M2inA = ON;
            M2inB = OFF;
            M2pwm = mPWM;
            //motor 2
            M12inA = OFF;
            M12inB = ON;
            M12pwm = OFF;
            //motor 3
            pc.printf("\n up \n");
        }

    void left()
        {
            M1inA = ON;
            M1inB = OFF;
            M1pwm = mPWM;
            //motor 1
            M2inA = OFF;
            M2inB = ON;
            M2pwm = OFF; 
            //motor 2
            M12inA = OFF;
            M12inB = ON;
            M12pwm = mPWM;
            //motor 3
            pc.printf("\n left \n");
        }
        
    void right()
        {
            M1inA = ON;
            M1inB = OFF;
            M1pwm = OFF;
            //motor 1
            M2inA = OFF;
            M2inB = ON;
            M2pwm = mPWM;
            //motor 2
            M12inA = ON;
            M12inB = OFF;
            M12pwm = mPWM;
            //motor 3
            pc.printf("\n right \n");
        }                                                       
    /////////////////////////////////////////////////////////////
    
    int main()
    {
        while(1) {
        rotate_right();
        VL53L0X();
        colors();
        wait(5);
        rotate_left();
        VL53L0X();
        colors();
        wait(5);
        up();
        VL53L0X();
        colors();
        wait(5);
        left();
        VL53L0X();
        colors();
        wait(5);
        right();
        VL53L0X();
        colors();
        }
    } 