#include "Steering.h"

void HomeScreen()
{
    CANMessage Rxmsg;
    ftc rcv,send;
    
    send.FLOAT=45.4444;
    Rxmsg.id=BATTERY_VOLTAGE_ID;
    for(int i=0; i<4; i++)
        Rxmsg.data[i]=send.C_FLOAT[i];
    display.ClearScreen();
    display.SelectFont(Arial12,BLACK,ReadData);
    if(CAN_Steering.read(Rxmsg))
    {
        for(int i=0; i<4; i++)
            rcv.C_FLOAT[i]=Rxmsg.data[i];
        if(Rxmsg.id == BATTERY_VOLTAGE_ID)
        {
            display.GotoXY(0,0);
            display.PrintString(" PV: ");     
            display.PrintNumber(rcv.FLOAT);
            display.PrintString("V");
        }
        if(Rxmsg.id == BATTERY_POWER_ID)
        {
            display.GotoXY(0,16);
            display.PrintString(" PP: ");        
            display.PrintNumber(rcv.FLOAT);
            display.PrintString("KW");
        }
        if(Rxmsg.id == BATTERY_STATE_ID)
        {
            display.GotoXY(0,32);
            display.PrintString(" STATE: ");      
            display.PrintString(rcv.C_FLOAT);
        }
    }
    wait(2);
    return;    
}

/*
void ShutdwnScreen()
{
    screen=1;
    CANMessage Rxmsg;
    uint16_t recv=0, temp=0, i=0;
    //Test
    
        //uint16_t Rxpoll=15;
        //char Result[4]={0};
        //Result[0]=(char)(Rxpoll&0x00ff);
        //Result[1]=(char)((Rxpoll&0xff00)>>8);
        //CANMessage Rxmsg(410,Result,sizeof(Result));
        
    display.ClearScreen();
    display.GotoXY(0,0);
    display.SelectFont(Arial12,BLACK,ReadData);
    display.PrintString("SHTDWN SWTCH OPEN");

        if(CAN_Steering.read(Rxmsg))
        {
            if(Rxmsg.id == SWITCH_ID)
            {
                recv=(((uint16_t)Rxmsg.data[1]<<8) | (0x00ff&(uint16_t)Rxmsg.data[0]));
                display.GotoXY(0,16);
                while(i < 12)
                {
                    temp=recv;
                    if(((temp & (1 << i))>>i) == 1)
                    {
                        display.GotoXY(SwitchPosition[i][0],SwitchPosition[i][1]);
                        display.PrintString(SwitchName[i]);
                    }    
                }
            }
        }
        return;    
}    

void AMS1Screen()
{
    screen=2;
    CANMessage Rxmsg;
    ftc rcv;
    rcv.FLOAT=0.0;
    
    display.ClearScreen();
    display.SelectFont(Arial12,BLACK,ReadData);
   
    if(CAN_Steering.read(Rxmsg))
    {
        for(int i=0; i<4; i++)
            rcv.C_FLOAT[i]=Rxmsg.data[i];
        if(Rxmsg.id == BATTERY_VOLTAGE_ID)
        {
            display.GotoXY(0,0);
            display.PrintString(" PV: ");     
            display.PrintNumber(rcv.FLOAT);
            display.PrintString("V");
        }
        if(Rxmsg.id == BATTERY_POWER_ID)
        {
            display.GotoXY(0,16);
            display.PrintString(" PV: ");     
            display.PrintNumber(rcv.FLOAT);
            display.PrintString("KW");
        }
        if(Rxmsg.id == BATTERY_CURRENT_ID)
        {
            display.GotoXY(0,32);
            display.PrintString(" PC: ");        
            display.PrintNumber(rcv.FLOAT);
            display.PrintString("KW");
        }
    }   
}

void AMS2Screen()
{
    screen=3;
    CANMessage Rxmsg;
    ftc rcv;
    rcv.FLOAT=0.0;
    
    display.ClearScreen();
    display.SelectFont(Arial12,BLACK,ReadData);
    
    if(CAN_Steering.read(Rxmsg))
    {   
        for(int i=0; i<4; i++)
                rcv.C_FLOAT[i]=Rxmsg.data[i];
        if(Rxmsg.id == BATTERY_MIN_CELLVOLTAGE_ID)
        {
            display.GotoXY(0,0);
            display.PrintString(" Min Cell V:");
            display.PrintNumber(rcv.FLOAT);
            display.PrintString("V");
        }
        if(Rxmsg.id == BATTERY_MAX_CELLVOLTAGE_ID)
        {
            display.GotoXY(0,16);
            display.PrintString(" Max Cell V:");
            display.PrintNumber(rcv.FLOAT);
            display.PrintString("V");
        }
        if(Rxmsg.id == BATTERY_AVG_CELLVOLTAGE_ID)
        {
            display.GotoXY(0,32);
            display.PrintString(" Max Cell V:");
            display.PrintNumber(rcv.FLOAT);
            display.PrintString("V");
        }
    }   
}

void AMS3Screen()
{
    screen=4;
    CANMessage Rxmsg;    
    ftc rcv;
    rcv.FLOAT=0.0;
    
    display.ClearScreen();
    display.SelectFont(Arial12,BLACK,ReadData);
    
    if(CAN_Steering.read(Rxmsg))
    {   
        for(int i=0; i<4; i++)
                rcv.C_FLOAT[i]=Rxmsg.data[i];
        if(Rxmsg.id == BATTERY_MIN_CELLTEMPERATURE_ID)
        {
            display.GotoXY(0,0);
            display.PrintString(" Min Cell T:");
            display.PrintNumber(rcv.FLOAT);
            display.PrintString("deg");
        }
        if(Rxmsg.id == BATTERY_MAX_CELLTEMPERATURE_ID)
        {
            display.GotoXY(0,16);
            display.PrintString(" Max Cell T:");
            display.PrintNumber(rcv.FLOAT);
            display.PrintString("deg");
        }
        if(Rxmsg.id == BATTERY_AVG_CELLTEMPERATURE_ID)
        {
            display.GotoXY(0,32);
            display.PrintString(" Avg Cell T:");
            display.PrintNumber(rcv.FLOAT);
            display.PrintString("deg");
        }
    }   
}

void AMS4Screen()
{
    screen =5;
    CANMessage Rxmsg;
    ftc rcv;
    
    display.ClearScreen();
    display.SelectFont(Arial12,BLACK,ReadData);
    
    if(CAN_Steering.read(Rxmsg))
    {   
        for(int i=0; i<4; i++)
                rcv.C_FLOAT[i]=Rxmsg.data[i];
        if(Rxmsg.id == AMS_AIRS_ID)
        {
            display.GotoXY(0,0);
            display.PrintString(" AIRS: ");
            display.PrintString(rcv.C_FLOAT);
        }
        if(Rxmsg.id == AMS_PRECHARGING_ID)
        {
            display.GotoXY(0,16);
            display.PrintString(" Precharging: ");
            display.PrintString(rcv.C_FLOAT);
        }
    }   
}
*/
void ON()
{
    char OnData[4]="ON";
    CANMessage Txmsg(101,OnData,sizeof(OnData));
    wait(0.1);
    
    display.ClearScreen();
    display.SelectFont(Arial12,BLACK,ReadData);
    display.GotoXY(16,16);
    display.PrintString(" ON    INITIATED");
    //screen=0;
    return;
}

void ResetCommand()
{
    char ResetData[4]="RES";
    CANMessage Txmsg(102,ResetData,sizeof(ResetData));
    wait(0.1);
    
    display.ClearScreen();
    display.SelectFont(Arial12,BLACK,ReadData);
    display.GotoXY(16,16);
    display.PrintString(" RESET INITIATED");
    //screen=0;
    
    return;
}

void Init()
{
    pc.baud(230400);
    CAN_Steering.frequency(500000);
}

int main()
{
    Init();
    //int flag=1;
    wait(0.1);
    display.GotoXY(10,16);
    display.SelectFont(Arial_14,BLACK,ReadData);
    display.PrintString("Penn Electric Racing");
    display.GotoXY(20,32); 
    display.PrintString("Live The Dream");
    screen=0;
    wait(2);
    
    while(1)
    {
        if(biSWBL.read())
            HomeScreen();
        
        if(biSWTR.read())
            ON();
        
        if(biSWTL.read())
            ResetCommand();
        
        printf("SCreen:%d\n\r",screen);        
        wait(0.1);    
    }   
}    

/*
        else if(screen == 1)
            ShutdwnScreen();  
        else if(screen == 2)
            AMS1Screen();    
        else if(screen == 3)
            AMS2Screen();    
        else if(screen == 4)
            AMS3Screen();    
        else if(screen == 5)
            AMS4Screen();    
        */
        /*
        if(biSWBR.read())
        {
            if(screen == maxScreen)
                screen=0;
            else    
                ++screen;
            wait(1);
        }
        */