#include "Steering.h"

void HomeScreen()
{
    CANMessage Rxmsg;
    ftc rcv;
    rcv.FLOAT=0.0;
    char dat[4];
    float power_ratio=0.0;
    printf("Homescreen\n\r");
    display.ClearScreen();
    display.SelectFont(Arial12,BLACK,ReadData);
    display.GotoXY(0,0);
    display.PrintString(" HOME SCREEN");
    while( !(biSWTL.read() || biSWTR.read() || biSWBR.read()) )
    {
        if(CAN_Steering.read(Rxmsg))
        {
            for(int i=0; i<4; i++)
                rcv.C_FLOAT[i]=Rxmsg.data[i];
            if(Rxmsg.id == BATTERY_VOLTAGE_ID)
            {
                display.GotoXY(0,16);
                display.PrintString(" PV: ");     
                sprintf(dat,"%2.2f",rcv.FLOAT);
                display.PrintString(dat);
                display.PrintString("V");
            }
            if(Rxmsg.id == BATTERY_POWER_ID)
            {
                display.GotoXY(64,16);
                display.PrintString(" PP: ");
                power_ratio=rcv.FLOAT/10000;        
                sprintf(dat,"%2.2f",power_ratio);
                display.PrintString(dat);
                display.PrintString("kW");
            }
            if(Rxmsg.id == PCM_STATE_ID)
            {
                display.GotoXY(0,32);
                display.PrintString(" STATE: ");      
                display.PrintNumber(rcv.FLOAT);
            }
        }
    }    
    return;    
}

void AMSScreen1()
{
    CANMessage Rxmsg;
    ftc rcv;
    char dat[4];
    rcv.FLOAT=0.0;
    printf("AMSScreen1");
    display.ClearScreen();
    display.SelectFont(Arial12,BLACK,ReadData);
    while( !(biSWTL.read() || biSWTR.read() || biSWBL.read()) )
    {
        printf("iN LOOP1");
        if(CAN_Steering.read(Rxmsg))
        {
            for(int i=0; i<4; i++)
                rcv.C_FLOAT[i]=Rxmsg.data[i];
            if(Rxmsg.id == BATTERY_VOLTAGE_ID)
            {
                display.GotoXY(0,0);
                display.PrintString(" pv: ");
                sprintf(dat,"%2.2f",rcv.FLOAT);
                display.PrintString(dat);
            }
            if(Rxmsg.id == BATTERY_POWER_ID)
            {
                display.GotoXY(0,16);
                display.PrintString(" pp: ");
                sprintf(dat,"%2.2f",rcv.FLOAT);
                display.PrintString(dat);
            }
            if(Rxmsg.id == BATTERY_CURRENT_ID)
            {
                display.GotoXY(0,32);
                display.PrintString(" pi: ");
                sprintf(dat,"%2.2f",rcv.FLOAT);
                display.PrintString(dat);
            }
            
            //Column 2
            if(Rxmsg.id == BATTERY_MIN_CELLVOLTAGE_ID)
            {
                display.GotoXY(49,0);
                display.PrintString(" min cell V: ");
                sprintf(dat,"%2.2f",rcv.FLOAT);
                display.PrintString(dat);
            }
            if(Rxmsg.id == BATTERY_MAX_CELLVOLTAGE_ID)
            {
                display.GotoXY(49,16);
                display.PrintString(" max cell V: ");
                sprintf(dat,"%2.2f",rcv.FLOAT);
                display.PrintString(dat);
            }
            if(Rxmsg.id == BATTERY_AVG_CELLVOLTAGE_ID)
            {
                display.GotoXY(49,32);
                display.PrintString(" avg cell V: ");
                sprintf(dat,"%2.2f",rcv.FLOAT);
                display.PrintString(dat);
            }
        }
        screen=1;                 
    }   
    return;   
}    

void AMSScreen2()
{
    CANMessage Rxmsg;
    ftc rcv;
    char dat[4];
    //ftc send;
    rcv.FLOAT=0.0;
    //send.FLOAT=65.6432;
    printf("AMSScreen2\n\r");
    display.ClearScreen();
    display.SelectFont(Arial12,BLACK,ReadData);
    while( !(biSWTL.read() || biSWTR.read() || biSWBL.read()) )
    {
        printf("iN LOOP2");
        if(CAN_Steering.read(Rxmsg))
        {
            for(int i=0; i<4; i++)
                rcv.C_FLOAT[i]=Rxmsg.data[i];
            if(Rxmsg.id == BATTERY_MIN_CELLTEMPERATURE_ID)
            {
                display.GotoXY(0,0);
                display.PrintString(" mn cll T: ");
                sprintf(dat,"%2.2f",rcv.FLOAT);
                display.PrintString(dat);
            }
            if(Rxmsg.id == BATTERY_MAX_CELLTEMPERATURE_ID)
            {
                display.GotoXY(0,16);
                display.PrintString(" mx cll T: ");
                sprintf(dat,"%2.2f",rcv.FLOAT);
                display.PrintString(dat);
            }
            if(Rxmsg.id == BATTERY_AVG_CELLTEMPERATURE_ID)
            {
                display.GotoXY(0,32);
                display.PrintString(" avg cell T: ");
                sprintf(dat,"%2.2f",rcv.FLOAT);
                display.PrintString(dat);
            }
            
            //Column 2
            if(Rxmsg.id == AMS_BATTERY_STATE)
            {
                if((rcv.C_FLOAT[0] & 0xC0) == 0xC0)
                {
                    display.GotoXY(70,0);
                    display.PrintString(" AIRS: ");
                    display.PrintString("CLOS");
                }
                else
                {
                    display.GotoXY(70,0);
                    display.PrintString(" AIRS: ");
                    display.PrintString("OPEN");
                }
                
                if((rcv.C_FLOAT[0] & 0x04) == 0x04)
                {
                    display.GotoXY(70,16);
                    display.PrintString(" Prchrg: ");
                    display.PrintString("on");
                }
                else
                {
                    display.GotoXY(70,16);
                    display.PrintString(" Prchrg: ");
                    display.PrintString("off");
                }                
            }
            if(Rxmsg.id == AMS_BATTERY_STATE)
            {
                display.GotoXY(70,16);
                display.PrintString(" Prchrg: ");
                display.PrintString("off");
            }
        }
        screen=0;         
    }
    return;        
}

void ON()
{
    Txmsg_Drive.data[0]|=(1<<0);   
    wait(0.1);
    
    display.ClearScreen();
    display.SelectFont(Arial12,BLACK,ReadData);
    display.GotoXY(26,16);
    display.PrintString(" ON    INITIATED");
    printf("ON Initiated\n\r");
    //screen=0;
    return;
}

void ResetCommand()
{
    Txmsg_Drive.data[0]&=~(1<<0);
    wait(0.1);
    
    display.ClearScreen();
    display.SelectFont(Arial12,BLACK,ReadData);
    display.GotoXY(16,16);
    display.PrintString(" RESET INITIATED");
    printf("Reset Initiated\n\r");
    //screen=0;
    
    return;
}    

void Powerstream()
{
    CANMessage Rxmsg;
    float power_ratio;
    ftc rcv;
    rcv.FLOAT=0.0;
    if(CAN_Steering.read(Rxmsg))
    {   
        if(Rxmsg.id == BATTERY_POWER_ID)
        {
            for(int i=0; i<4; i++)
                rcv.C_FLOAT[i]=Rxmsg.data[i];
            power_ratio=rcv.FLOAT/80000;
            ledstream.write(power_ratio);
        }
    }   
}

void Init()
{
    pc.baud(230400);
    CAN_Steering.frequency(500000);
    for(int i = 0; i<4; i++)
        drive[i] = (0x00);
    ledstream.write(0);
    call_ledstream.attach(&Powerstream,0.1);
}

int main()
{
    Init();
    //int flag=1;
    wait(0.1);
    display.GotoXY(10,16);
    display.SelectFont(Arial_14,BLACK,ReadData);
    display.PrintString("Penn Electric Racing");
    display.GotoXY(20,32); 
    display.PrintString("Live The Dream");
    screen=0;
    wait(1);
    
    while(1)
    {
        if(biSWBL.read())
            HomeScreen();
        
        if(biSWTR.read())
        {
            ON();
            wait(1);
            HomeScreen();
        }
        if(biSWTL.read())
        {
            ResetCommand();
            wait(1);
            HomeScreen();
        }
        if(biSWBR.read())
        { 
            if(screen)
                AMSScreen2();
            else
                AMSScreen1();   
        }
        CAN_Steering.write(Txmsg_Drive);        
        wait(0.3);    
    }        
}    
