#include "mbed.h"
#include "C12832_lcd.h"
#include "LM75B.h"
#include "XBeeLib.h"

#if defined(ENABLE_LOGGING)
#include "DigiLoggerMbedSerial.h"
using namespace DigiLog;
#endif

#define REMOTE_NODE_ADDR16      ((uint16_t)0x0)

using namespace XBeeLib;

const int NODE_MODE=0; //0 = send reading, 1 = receive command
LM75B tempSensor(p28,p27);
C12832_LCD lcd;
AnalogIn current(p17);
DigitalOut leds [] ={(LED1),(LED2)};
XBee802 xbee = XBee802(RADIO_TX, RADIO_RX, RADIO_RESET, NC, NC, 9600);
const RemoteXBee802 remoteDevice16b = RemoteXBee802(REMOTE_NODE_ADDR16);
char send_data [98];

void clear_send_data() {
    for (int i=0;i<98;i++) send_data[i]=0;
}

int calculate_send_data_size() {
    for (int i=0;i<98;i++) if (send_data[i]==0) return i;
    return 98;
}

void sendTemp(const char* format, XBee802& xbee, const RemoteXBee802& remoteDevice) {
    leds[0]=1;
    snprintf(send_data,98,format,(tempSensor.temp()+55)/(175));
    
    xbee.send_data(remoteDevice,(const uint8_t *)send_data,calculate_send_data_size());
    clear_send_data();
    leds[0]=0;
}

void sendCurrent(const char* format, XBee802& xbee, const RemoteXBee802& remoteDevice) {
    leds[1]=1;
    float max=0.0;
    time_t start=time(NULL);
    while (time(NULL)-start<2) {
        float value=1.0-current;
        if (value>0 && value>max) max=value;
    }
    
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Waterflow : %f L/min",max*19.8);
    snprintf(send_data,98,format,max);
            
    xbee.send_data(remoteDevice,(const uint8_t *)send_data,calculate_send_data_size());
    clear_send_data();
    leds[1]=0;
}

const char tempFormat []="0;Toilet_Monitor;ToiletTemperature;%f";
const char currentFormat []="0;Toilet_Monitor;ToiletWaterflow;%f";

void sendReadings () {
    while (1) {
        sendTemp(tempFormat,xbee,remoteDevice16b);
        wait(0.1);
        sendCurrent(currentFormat,xbee,remoteDevice16b);
        wait(58.0);
    }
}
int main()
{
    set_time(0);
    mbed_interface_disconnect(); //Disable debugging to improve ADC precision. | Comment this if you need debugging via serial.
    
    RadioStatus radioStatus = xbee.init();
    MBED_ASSERT(radioStatus == Success);
    
    if (NODE_MODE==0) {
        sendReadings();
    } else {}
}